/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.representation.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.architecture.representation.provider.EClassPropertyDescriptor;
import org.eclipse.papyrus.infra.architecture.representation.provider.RuleItemProvider;
import org.eclipse.papyrus.infra.architecture.representation.provider.StereotypePropertyDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.representation.ChildRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationFactory;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.gmfdiag.representation.provider.RepresentationEditPlugin;

public class ChildRuleItemProvider
extends RuleItemProvider {
    public ChildRuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addElementPropertyDescriptor(object);
            this.addStereotypesPropertyDescriptor(object);
            this.addOriginPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addElementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EClassPropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_element_feature"), this.getString("_UI_ChildRule_element_description"), (EStructuralFeature)RepresentationPackage.Literals.CHILD_RULE__ELEMENT, true, false, true, null, null, null)));
    }

    protected void addStereotypesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new StereotypePropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_stereotypes_feature"), this.getString("_UI_ChildRule_stereotypes_description"), (EStructuralFeature)RepresentationPackage.Literals.CHILD_RULE__STEREOTYPES, true, false, true, null, null, null)));
    }

    protected void addOriginPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EClassPropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_origin_feature"), this.getString("_UI_ChildRule_origin_description"), (EStructuralFeature)RepresentationPackage.Literals.CHILD_RULE__ORIGIN, true, false, true, null, null, null)));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(RepresentationPackage.Literals.CHILD_RULE__INSERTION_PATH);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ChildRule"));
    }

    public String getText(Object object) {
        ChildRule rule = (ChildRule)object;
        StringBuilder builder = new StringBuilder("[");
        builder.append(rule.getOrigin() != null ? rule.getOrigin().getName() : "#");
        builder.append("] add: ");
        if (!rule.getStereotypes().isEmpty()) {
            builder.append("<<");
            int i = 0;
            while (i != rule.getStereotypes().size()) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(((EClass)rule.getStereotypes().get(i)).getName());
                ++i;
            }
            builder.append(">> ");
        }
        builder.append(rule.getElement() != null ? rule.getElement().getName() : "#");
        builder.append(" => ");
        builder.append(rule.isPermit() ? "allow" : "deny");
        return builder.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ChildRule.class)) {
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(RepresentationPackage.Literals.CHILD_RULE__INSERTION_PATH, RepresentationFactory.eINSTANCE.createPathElement()));
    }

    public ResourceLocator getResourceLocator() {
        return RepresentationEditPlugin.INSTANCE;
    }
}

