/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.NotificationManager;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.InducedRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.ChildrenListRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.CreateInducedRepresentationViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionSingleton;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionsRegistry;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class InducedRepresentationCreationEditPolicy
extends GraphicalEditPolicy {
    public static final String INDUCED_REPRESENTATION_CREATOR_EDITPOLICY = "InducedRepresentationCreationEditPolicy";
    protected NotificationManager notificationManager;
    protected DiagramExpansionsRegistry diagramExpansionRegistry = DiagramExpansionSingleton.getInstance().getDiagramExpansionRegistry();

    public void activate() {
        super.activate();
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.updateAddedCompartment();
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        super.deactivate();
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void executeShapeCompartmentCreation(IGraphicalEditPart editPart, HashMap<String, View> existedDynamicCompartment, List<String> wantedChildreenID, ChildrenListRepresentation listRepresentation) {
        for (String wantedID : wantedChildreenID) {
            if (existedDynamicCompartment.get(wantedID) != null || !(listRepresentation.IDMap.get(wantedID) instanceof InducedRepresentation)) continue;
            try {
                TransactionalEditingDomain domain = this.getEditingDomain(editPart);
                CreateInducedRepresentationViewCommand command = new CreateInducedRepresentationViewCommand(domain, "view Creation", wantedID, "view Creation", editPart.getNotationView(), true, editPart.getDiagramPreferencesHint());
                GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected TransactionalEditingDomain getEditingDomain(IGraphicalEditPart editPart) {
        return editPart.getEditingDomain();
    }

    protected String getDiagramType(View currentView) {
        Diagram diagram = currentView.getDiagram();
        String currentDiagramType = null;
        ViewPrototype viewPrototype = DiagramUtils.getPrototype((Diagram)diagram);
        currentDiagramType = viewPrototype != null ? viewPrototype.getLabel() : diagram.getType();
        return currentDiagramType;
    }

    public void updateAddedCompartment() {
        IGraphicalEditPart editPart = (IGraphicalEditPart)this.getHost();
        View view = editPart.getNotationView();
        String diagramType = this.getDiagramType(view);
        ChildrenListRepresentation listRepresentation = this.diagramExpansionRegistry.mapChildreen.get(diagramType);
        if (listRepresentation == null) {
            return;
        }
        List<String> childreenID = listRepresentation.parentChildrenRelation.get(view.getType());
        if (childreenID == null) {
            return;
        }
        HashMap<String, View> dynamicCompartments = this.getAddedCompartmentView(view, childreenID);
        if (dynamicCompartments.size() < childreenID.size()) {
            this.executeShapeCompartmentCreation(editPart, dynamicCompartments, childreenID, listRepresentation);
        }
    }

    private HashMap<String, View> getAddedCompartmentView(View view, List<String> childreenID) {
        HashMap<String, View> dynamicCompartments = new HashMap<String, View>();
        for (Object child : view.getChildren()) {
            if (!(child instanceof View) || !childreenID.contains(((View)child).getType())) continue;
            dynamicCompartments.put(((View)child).getType(), (View)child);
        }
        return dynamicCompartments;
    }
}

