/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.actionprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.views.modelexplorer.actionprovider.AbstractSubmenuActionProvider;
import org.eclipse.papyrus.views.modelexplorer.factory.IActionHandlerFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.osgi.framework.Bundle;

public class EditingDomainActionProvider
extends AbstractSubmenuActionProvider {
    public static final String ACTION_HANDLER_EXTENSION_POINT_ID = "org.eclipse.papyrus.views.modelexplorer.actionHandler";
    protected CommonNavigator activeViewPart;
    protected Map<IActionHandlerFactory, ActionProperties> actionsFactoriesMap;

    public void init(ICommonActionExtensionSite site) {
        IConfigurationElement[] registry;
        super.init(site);
        this.activeViewPart = this.getCommonNavigator();
        this.actionsFactoriesMap = new HashMap<IActionHandlerFactory, ActionProperties>();
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        IConfigurationElement[] iConfigurationElementArray = registry = Platform.getExtensionRegistry().getConfigurationElementsFor(ACTION_HANDLER_EXTENSION_POINT_ID);
        int n = registry.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            try {
                String actionId = elt.getAttribute("actionId");
                String afterAction = elt.getAttribute("afterAction");
                boolean needSeparator = Boolean.valueOf(elt.getAttribute("needSeparator"));
                ActionProperties properties = new ActionProperties(actionId, afterAction, needSeparator);
                IActionHandlerFactory factory = (IActionHandlerFactory)EditingDomainActionProvider.createExtension(elt, elt.getAttribute("actionHandler"));
                factory.createActions((EditingDomain)editingDomain);
                this.actionsFactoriesMap.put(factory, properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        for (IActionHandlerFactory factory : this.actionsFactoriesMap.keySet()) {
            factory.fillActionBars(actionBars);
        }
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension " + e);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        this.update();
        List<IActionHandlerFactory> sortedFactories = this.sortFactories(this.actionsFactoriesMap);
        for (IActionHandlerFactory factory : sortedFactories) {
            ActionProperties actionProperties = this.actionsFactoriesMap.get(factory);
            if (actionProperties != null && actionProperties.isNeedSeparator()) {
                menu.add((IContributionItem)new Separator());
            }
            for (Action action : factory.getActions()) {
                menu.add((IContributionItem)new ActionContributionItem((IAction)action));
            }
        }
        this.activate();
    }

    public void update() {
        ISelection selection = this.getCommonNavigator().getCommonViewer().getSelection();
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        for (IActionHandlerFactory factory : this.actionsFactoriesMap.keySet()) {
            factory.update((IStructuredSelection)structuredSelection);
        }
    }

    public void activate() {
        for (IActionHandlerFactory factory : this.actionsFactoriesMap.keySet()) {
            factory.activate(this.activeViewPart);
        }
        this.update();
    }

    public void deactivate() {
        for (IActionHandlerFactory factory : this.actionsFactoriesMap.keySet()) {
            factory.deactivate(this.activeViewPart);
        }
    }

    public void updateActionBars() {
        super.updateActionBars();
        this.activate();
        this.update();
    }

    private List<IActionHandlerFactory> sortFactories(final Map<IActionHandlerFactory, ActionProperties> actionsFactoriesMap) {
        ArrayList<IActionHandlerFactory> factories = new ArrayList<IActionHandlerFactory>(actionsFactoriesMap.keySet());
        Collections.sort(factories, new Comparator<IActionHandlerFactory>(){

            @Override
            public int compare(IActionHandlerFactory factory1, IActionHandlerFactory factory2) {
                ActionProperties properties1 = this.getDefaultForNull((ActionProperties)actionsFactoriesMap.get(factory1));
                ActionProperties properties2 = this.getDefaultForNull((ActionProperties)actionsFactoriesMap.get(factory2));
                String after1 = properties1.getAfterAction();
                String after2 = properties2.getAfterAction();
                if (properties1.getActionId().equals(properties2.getActionId())) {
                    return 0;
                }
                if (properties1.getActionId().equals(after2)) {
                    return -1;
                }
                if (properties2.getActionId().equals(after1)) {
                    return 1;
                }
                if (after1 == null) {
                    return -1;
                }
                if (after2 == null) {
                    return 1;
                }
                return 0;
            }

            private ActionProperties getDefaultForNull(ActionProperties actionProperties) {
                if (actionProperties == null) {
                    actionProperties = new ActionProperties("", "", false);
                }
                return actionProperties;
            }
        });
        return factories;
    }

    private class ActionProperties {
        private final String actionId;
        private final String afterAction;
        private final boolean needSeparator;

        public ActionProperties(String actionId, String afterAction, boolean needSeparator) {
            this.actionId = actionId;
            this.afterAction = afterAction;
            this.needSeparator = needSeparator;
        }

        public String getActionId() {
            return this.actionId;
        }

        public String getAfterAction() {
            return this.afterAction;
        }

        public boolean isNeedSeparator() {
            return this.needSeparator;
        }
    }
}

