/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator.CellEditorLocatorAccess;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure;
import org.eclipse.swt.widgets.Text;

public class MultilineCellEditorLocator
implements CellEditorLocator {
    private IMultilineEditableFigure multilineEditableFigure;

    public MultilineCellEditorLocator(IMultilineEditableFigure figure) {
        this.multilineEditableFigure = figure;
    }

    public IMultilineEditableFigure getMultilineEditableFigure() {
        return this.multilineEditableFigure;
    }

    public void relocate(CellEditor celleditor) {
        Text text = (Text)celleditor.getControl();
        Rectangle rect = this.getMultilineEditableFigure().getBounds().getCopy();
        rect.x = this.getMultilineEditableFigure().getEditionLocation().x;
        rect.y = this.getMultilineEditableFigure().getEditionLocation().y;
        this.getMultilineEditableFigure().translateToAbsolute((Translatable)rect);
        if (this.getMultilineEditableFigure().getText().length() > 0) {
            rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
        }
        if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof IMultilineEditableFigure) {
            return new MultilineCellEditorLocator((IMultilineEditableFigure)source.getFigure());
        }
        return CellEditorLocatorAccess.INSTANCE.getTextCellEditorLocator(source);
    }
}

