/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editparts.IEditpartListenerAccess;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ApplyStereotypeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.edge.UMLEdgeFigure;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class UMLConnectionNodeEditPart
extends ConnectionEditPart
implements IUMLEditPart,
IEditpartListenerAccess {
    public UMLConnectionNodeEditPart(View view) {
        super(view);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        Element element = this.getUMLElement();
        if (element == null) {
            return;
        }
        this.addListenerFilter("StereotypableElement", (NotificationListener)this, this.resolveSemanticElement());
        for (EObject stereotypeApplication : element.getStereotypeApplications()) {
            this.addListenerFilter("StereotypedElement", (NotificationListener)this, stereotypeApplication);
        }
    }

    @Override
    public final Iterator getEventListenerIterator(Class clazz) {
        return this.getEventListeners(clazz);
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        int eventType = event.getEventType();
        if (eventType == 31) {
            this.addListenerFilter("StereotypedElement", (NotificationListener)this, (EObject)event.getNewValue());
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("applyStereotype", (EditPolicy)new ApplyStereotypeEditPolicy());
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ShowHideLabelEditPolicy());
    }

    public EditPart getTargetEditPart(Request request) {
        if ("applyStereotype".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public abstract UMLEdgeFigure getPrimaryShape();

    public void refreshAppliedStereotypes() {
        String stereotypesToDisplay = this.stereotypesToDisplay();
        Image imageToDisplay = this.stereotypeIconToDisplay();
        if (!"".equals(stereotypesToDisplay) || imageToDisplay != null) {
            this.getPrimaryShape().setStereotypeDisplay(stereotypesToDisplay, imageToDisplay);
        }
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        this.removeListenerFilter("StereotypableElement");
        this.removeListenerFilter("StereotypedElement");
    }

    @Override
    public Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    public String stereotypesToDisplay() {
        String stereotypesToDisplay = StereotypeDisplayUtil.getInstance().getStereotypeTextToDisplay((View)this.getModel());
        return stereotypesToDisplay;
    }

    public Image stereotypeIconToDisplay() {
        String stereotypesToDisplay = StereotypeDisplayUtil.getInstance().getStereotypeTextToDisplay((View)this.getModel());
        StringTokenizer tokenizer = new StringTokenizer(stereotypesToDisplay, ",");
        if (tokenizer.hasMoreTokens()) {
            String firstStereotypeName = tokenizer.nextToken();
            Stereotype stereotype = this.getUMLElement().getAppliedStereotype(firstStereotypeName);
            return Activator.getIconElement(this.getUMLElement(), stereotype, false);
        }
        return null;
    }

    protected void setLineWidth(int width) {
        this.getPrimaryShape().setLineWidth(width < 0 ? 1 : width);
    }
}

