/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLElementTreeAxisManagerForEventList;

public class EmptyLineUMLElementTreeAxisManagerForEventList
extends UMLElementTreeAxisManagerForEventList {
    private boolean createEmptyRow = false;

    public void setCreateEmptyRow(boolean createEmptyRow) {
        this.createEmptyRow = createEmptyRow;
    }

    protected ITreeItemAxis addObject(ITreeItemAxis parentAxis, Object objectToAdd) {
        ITreeItemAxis createdAxis = super.addObject(parentAxis, objectToAdd);
        if (this.createEmptyRow && objectToAdd instanceof TreeFillingConfiguration) {
            super.addObject(createdAxis, null);
        }
        return createdAxis;
    }

    protected void fillChildrenForSemanticElement(ITreeItemAxis axis) {
        if (this.createEmptyRow) {
            List confs;
            Object context;
            int nextDepth;
            if (axis == null) {
                nextDepth = 0;
                context = this.getTableContext();
                confs = FillingConfigurationUtils.getTreeFillingConfigurationForDepth((Table)this.getTable(), (AxisManagerRepresentation)this.representedAxisManager, (int)nextDepth);
                for (TreeFillingConfiguration current : confs) {
                    Collection values = this.getFilteredValueAsCollection(current, context, nextDepth);
                    ITreeItemAxis newAxis = this.addObject(axis, current);
                    if (nextDepth != 0) continue;
                    for (Object curr : values) {
                        this.addObject(newAxis, curr);
                    }
                }
            }
            if (axis != null && axis.getElement() != null && axis.getChildren().size() == 0) {
                nextDepth = this.getSemanticDepth(axis) + 1;
                context = axis.getElement();
                Assert.isTrue((!(context instanceof TreeFillingConfiguration) ? 1 : 0) != 0);
                confs = FillingConfigurationUtils.getTreeFillingConfigurationForDepth((Table)this.getTable(), (AxisManagerRepresentation)this.representedAxisManager, (int)nextDepth);
                for (TreeFillingConfiguration current : confs) {
                    ITreeItemAxis newAxis = this.addObject(axis, current);
                    Collection values = this.getFilteredValueAsCollection(current, context, nextDepth);
                    if (values.size() == 0 || nextDepth != 0) continue;
                    for (Object curr : values) {
                        this.addObject(newAxis, curr);
                    }
                }
            }
        } else {
            super.fillChildrenForSemanticElement(axis);
        }
    }
}

