/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.databinding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableValue;

public class EObjectStructuredObservableValue
extends EMFObservableValue {
    protected List<EObjectObservableValue> observables = new ArrayList<EObjectObservableValue>();
    protected EObjectStructuredObservableValue parent;

    public EObjectStructuredObservableValue(EObject eObject, EStructuralFeature eStructuralFeature, EditingDomain domain, boolean browseFeatures, EObjectStructuredObservableValue parent) {
        super(eObject, eStructuralFeature, domain);
        this.parent = parent;
        if (eObject != null && browseFeatures) {
            this.browseFeatures(eObject);
        }
    }

    public List<EObjectObservableValue> getObservables() {
        return this.observables;
    }

    public EObjectStructuredObservableValue getParent() {
        return this.parent;
    }

    private void browseFeatures(EObject eObject) {
        EList eStructuralFeatures = eObject.eClass().getEStructuralFeatures();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
            Object eGet = eObject.eGet(eStructuralFeature);
            EObjectStructuredObservableValue eObjectObservableValue = eStructuralFeature instanceof EReference && eGet instanceof EObject ? new EObjectStructuredObservableValue((EObject)eGet, eStructuralFeature, (EditingDomain)editingDomain, true, this) : new EObjectStructuredObservableValue(eObject, eStructuralFeature, (EditingDomain)editingDomain, false, this);
            this.observables.add(eObjectObservableValue);
        }
    }

    public Object getValueType() {
        Object valueType = super.getValueType();
        if (valueType == null && this.eObject != null) {
            valueType = this.eObject.eClass();
        }
        return valueType;
    }

    public synchronized void dispose() {
        for (EObjectObservableValue eObjectObservableValue : this.observables) {
            eObjectObservableValue.dispose();
        }
        super.dispose();
    }
}

