/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.metamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.metamodel.IRegisteredMetamodel;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;

public class RegisteredMetamodel
extends RegisteredElementExtensionPoint
implements IRegisteredMetamodel {
    private static final String TAG_METAMODEL = "metamodel";

    public RegisteredMetamodel(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public static List<IRegisteredMetamodel> getRegisteredMetamodels() {
        ArrayList<IRegisteredMetamodel> metamodels = new ArrayList<IRegisteredMetamodel>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.uml.extensionpoints.UMLMetamodel");
        int j = 0;
        while (j < configElements.length) {
            IRegisteredMetamodel proxy = RegisteredMetamodel.parseMetamodelExtension(configElements[j], metamodels.size());
            if (proxy != null) {
                metamodels.add(proxy);
            }
            ++j;
        }
        return metamodels;
    }

    public static IRegisteredMetamodel getRegisteredMetamodel(String name) {
        return RegisteredMetamodel.getRegisteredMetamodel(name, null);
    }

    public static IRegisteredMetamodel getRegisteredMetamodel(String name, String path) {
        Assert.isNotNull((Object)name);
        IRegisteredMetamodel[] metamodels = RegisteredMetamodel.getRegisteredMetamodels().toArray(new IRegisteredMetamodel[0]);
        int i = 0;
        while (i < metamodels.length) {
            IRegisteredMetamodel metamodel = metamodels[i];
            if (name.equals(metamodel.getName())) {
                if (path == null) {
                    return metamodel;
                }
                if (path.equals(metamodel.getPath())) {
                    return metamodel;
                }
            }
            ++i;
        }
        return null;
    }

    private static IRegisteredMetamodel parseMetamodelExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_METAMODEL.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredMetamodel(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load metamodel named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

