/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.internal.preferences.ITabTooltipPreferences;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TabTooltipPreferences
implements ITabTooltipPreferences {
    protected IPreferenceStore store;

    public TabTooltipPreferences() {
        IPreferenceStore store = this.createPreferenceStore();
        this.setPreferenceStore(store);
    }

    protected IPreferenceStore createPreferenceStore() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName());
        return store;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.store = store;
    }

    @Override
    public boolean isTooltipEnable() {
        return this.store.getBoolean("isTooltipEnable");
    }

    @Override
    public boolean isTooltipForCurrentTabShown() {
        return this.store.getBoolean("isTooltipForCurrentTabShown");
    }

    @Override
    public float getScaledFactor() {
        return (float)this.store.getInt("scaledFactor") / 100.0f;
    }

    @Override
    public int getIntScaledFactor() {
        return this.store.getInt("scaledFactor");
    }

    @Override
    public int getTooltipAutoCloseDelay() {
        return this.store.getInt("tooltipAutoCloseDelay");
    }
}

