/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.contentprovider;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractPageModel
implements IPageModel {
    private ILabelProvider tabLabelProvider;
    private Consumer<String> onLabelChanged = this::noop;
    private final ILabelProviderListener labelListener = event -> {
        if (event.getElement() == this.getRawModel()) {
            this.onLabelChanged.accept(this.getTabTitle());
        }
    };

    public AbstractPageModel(ILabelProvider tabLabelProvider) {
        this.tabLabelProvider = Objects.requireNonNull(tabLabelProvider, "null tabLabelProvider");
        tabLabelProvider.addListener(this.labelListener);
    }

    @Override
    public void dispose() {
        this.tabLabelProvider.removeListener(this.labelListener);
        this.tabLabelProvider.dispose();
    }

    protected ILabelProvider getTabLabelProvider() {
        return this.tabLabelProvider;
    }

    @Override
    public String getTabTitle() {
        return this.tabLabelProvider.getText(this.getRawModel());
    }

    @Override
    public Image getTabIcon() {
        return this.tabLabelProvider.getImage(this.getRawModel());
    }

    public void onLabelChanged(Consumer<? super String> handler) {
        this.onLabelChanged = this.onLabelChanged.andThen(handler);
    }

    private void noop(String label) {
    }
}

