/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class OwnedAttributeHelper {
    public static final EStructuralFeature getOwnedAttributeFeatureForType(Type type) {
        if (type == null) {
            Activator.log.warn("The type is null!");
        }
        if (type instanceof StructuredClassifier) {
            return UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
        }
        if (type instanceof Interface) {
            return UMLPackage.eINSTANCE.getInterface_OwnedAttribute();
        }
        if (type instanceof DataType) {
            return UMLPackage.eINSTANCE.getDataType_OwnedAttribute();
        }
        if (type instanceof Artifact) {
            return UMLPackage.eINSTANCE.getArtifact_OwnedAttribute();
        }
        if (type instanceof Signal) {
            return UMLPackage.eINSTANCE.getSignal_OwnedAttribute();
        }
        String eClassName = type.eClass().getName();
        Activator.log.warn(String.format("Unknown type : %s", eClassName));
        EStructuralFeature feature = type.eClass().getEStructuralFeature("ownedAttribute");
        if (feature == null) {
            Activator.log.warn(String.format("Cannot find a valid feature for type %s.", eClassName));
        }
        return feature;
    }

    @Deprecated
    public static EStructuralFeature getFeatureForType(Type type) {
        return OwnedAttributeHelper.getOwnedAttributeFeatureForType(type);
    }

    public static ICommand getSetTypeOwnerForAssociationAttributeCommand(Association association, Property memberEnd) {
        ICommand command = null;
        EList ownerList = association.getEndTypes();
        Type ownerType = ((Type)ownerList.get(0)).equals(memberEnd.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
        EStructuralFeature ownedAttributeFeature = OwnedAttributeHelper.getOwnedAttributeFeatureForType(ownerType);
        if (ownedAttributeFeature != null) {
            ArrayList<Property> attributeList = new ArrayList<Property>();
            attributeList.addAll((Collection<Property>)((EList)ownerType.eGet(ownedAttributeFeature)));
            attributeList.add(memberEnd);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)ownerType);
            if (provider != null) {
                SetRequest request = new SetRequest((EObject)ownerType, ownedAttributeFeature, (Object)memberEnd);
                command = provider.getEditCommand((IEditCommandRequest)request);
            }
        }
        return command;
    }
}

