/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.sashmodel;

import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.BasicPageManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TransactionalBasicPageManagerImpl
extends BasicPageManagerImpl {
    private EditingDomain editingDomain;

    public TransactionalBasicPageManagerImpl(SashWindowsMngr diSashModel, EditingDomain editingDomain) {
        super(diSashModel);
        this.editingDomain = editingDomain;
    }

    public void closePage(Object pageIdentifier) {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.closePage(pageIdentifier));
    }

    public void closeAllOpenedPages() {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.closeAllOpenedPages());
    }

    public void closeOtherPages(Object pageIdentifier) {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.closeOtherPages(pageIdentifier));
    }

    public void openPage(Object pageIdentifier) {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.openPage(pageIdentifier));
    }

    public void openPage(Object pageIdentifier, String editorID) {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.openPage(pageIdentifier, editorID));
    }

    public void closeAllOpenedPages(Object pageIdentifier) {
        TransactionalBasicPageManagerImpl.run(this.editingDomain, () -> super.closeAllOpenedPages(pageIdentifier));
    }

    protected static void run(EditingDomain domain, Runnable writeOperation) {
        if (domain instanceof InternalTransactionalEditingDomain) {
            try {
                TransactionalBasicPageManagerImpl.run((InternalTransactionalEditingDomain)domain, writeOperation);
            }
            catch (Exception e) {
                Bundle self = FrameworkUtil.getBundle(TransactionalBasicPageManagerImpl.class);
                Status status = new Status(4, self.getSymbolicName(), "Sash model transaction failed.", (Throwable)e);
                Platform.getLog((Bundle)self).log((IStatus)status);
            }
        } else {
            writeOperation.run();
        }
    }

    private static void run(InternalTransactionalEditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        InternalTransaction transaction = domain.startTransaction(false, Collections.emptyMap());
        try {
            writeOperation.run();
        }
        finally {
            transaction.commit();
        }
    }
}

