/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.jface.preference;

import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.FontHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FontFieldEditor
extends FieldEditor {
    private Button fontBoldButton;
    private Button fontItalicButton;
    private Combo fontNameCombo;
    private Combo fontSizeCombo;
    protected static String VALUE_CHANGED_STRING = DiagramUIPropertiesMessages.AbstractPropertySection_UndoIntervalPropertyString;
    protected static final String FONT_COMMAND_NAME = String.valueOf(DiagramUIPropertiesMessages.Font_commandText) + " " + VALUE_CHANGED_STRING;
    protected static final String FONTS_AND_COLORS_LABEL = DiagramUIPropertiesMessages.FontAndColor_nameLabel;
    private FontData fontData;

    public FontFieldEditor(String preferenceName, Composite parent) {
        super(preferenceName, "", parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
    }

    protected void doLoad() {
        this.fontData = PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        this.initFontData();
    }

    protected void doLoadDefault() {
        this.fontData = PreferenceConverter.getDefaultFontData((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        this.initFontData();
    }

    private void initFontData() {
        this.fontNameCombo.setText(this.fontData.getName());
        this.fontSizeCombo.setText("" + this.fontData.getHeight());
        int style = this.fontData.getStyle();
        if ((style & 1) == 1) {
            this.fontBoldButton.setSelection(true);
        } else {
            this.fontBoldButton.setSelection(false);
        }
        if ((style & 2) == 2) {
            this.fontItalicButton.setSelection(true);
        } else {
            this.fontItalicButton.setSelection(false);
        }
    }

    protected void doStore() {
        this.fontData = new FontData();
        this.fontData.setName(this.fontNameCombo.getText());
        this.fontData.setHeight(Integer.parseInt(this.fontSizeCombo.getText()));
        this.fontData.setStyle(this.getStyle());
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (FontData)this.fontData);
    }

    private int getStyle() {
        int style = 0;
        if (this.fontBoldButton.getSelection()) {
            style |= 1;
        }
        if (this.fontItalicButton.getSelection()) {
            style |= 2;
        }
        return style;
    }

    public void dispose() {
        super.dispose();
        this.fontBoldButton.dispose();
        this.fontItalicButton.dispose();
        this.fontNameCombo.dispose();
        this.fontSizeCombo.dispose();
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected void createControl(Composite parent) {
        Composite compo = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        compo.setLayout((Layout)gl);
        this.fontNameCombo = new Combo(compo, 2060);
        this.fontNameCombo.setItems(FontHelper.getFontNames());
        GridData gridData = new GridData(1, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fontNameCombo.setLayoutData((Object)gridData);
        this.fontBoldButton = new Button(compo, 2);
        this.fontBoldButton.setImage(DiagramUIPropertiesImages.get((String)"icons/bold.gif"));
        this.fontItalicButton = new Button(compo, 2);
        this.fontItalicButton.setImage(DiagramUIPropertiesImages.get((String)"icons/italic.gif"));
        this.fontSizeCombo = new Combo(compo, 2060);
        this.fontSizeCombo.setItems(FontHelper.getFontSizes());
        gridData = new GridData(0x1000008, 0x1000000, true, false);
        this.fontSizeCombo.setLayoutData((Object)gridData);
    }
}

