/**
 * Copyright (c) 2017, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial implementation
 *    Artem Tikhomirov (Borland) - [235113] alternative parser access
 *                                 [244419] custom parsers
 *                                 initial API
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 * Benoit Maggi (CEA LIST) benoit.maggi@cea.fr - Initial API and implementation
 * Nicolas FAUVERGUE (ALL4TEC) nicolas.fauvergue@all4tec.net - Bug 496905
 * Gabriel Pascual (ALL4TEC) gabriel.pascual@all4tec.net - Bug 464625
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up parsers
 */
package parsers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParserImplementation;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenParsers;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LabelTextAccessMethod;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;

@Singleton
@SuppressWarnings("all")
public class PredefinedParser {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private Externalizer xptExternalizer;

  @Inject
  private Activator xptActivator;

  public CharSequence className(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }

  public CharSequence packageName(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    String _implPackageName = it.getHolder().getImplPackageName();
    _builder.append(_implPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence extendsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.common.parsers.AbstractElementTypeBasedAttributeParser");
    _builder.newLine();
    return _builder;
  }

  public CharSequence Main(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getHolder().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _fields = this.fields(it);
    _builder.append(_fields, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _aux_methods = this.aux_methods(it);
    _builder.append(_aux_methods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _parser_getEditStringMethod = this.parser_getEditStringMethod(it);
    _builder.append(_parser_getEditStringMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _parser_isValidEditStringMethod = this.parser_isValidEditStringMethod(it);
    _builder.append(_parser_isValidEditStringMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _parser_getParseCommandMethod = this.parser_getParseCommandMethod(it);
    _builder.append(_parser_getParseCommandMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _parser_getPrintStringMethod = this.parser_getPrintStringMethod(it);
    _builder.append(_parser_getPrintStringMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*            {@inheritDoc}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @see org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractFeatureParser#getModificationCommand(org.eclipse.emf.ecore.EObject, org.eclipse.emf.ecore.EStructuralFeature, java.lang.Object)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected org.eclipse.gmf.runtime.common.core.command.ICommand getModificationCommand(final org.eclipse.emf.ecore.EObject element, final org.eclipse.emf.ecore.EStructuralFeature feature, final Object value) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.common.core.command.ICommand result = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// If the feature to edit is the name, check that this is not really the internationalization to edit and not the name");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (feature.equals(org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getNamedElement_Name())) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils.getInternationalizationPreference(element) && null != org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement) element)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("final org.eclipse.papyrus.infra.core.resource.ModelSet modelSet = (org.eclipse.papyrus.infra.core.resource.ModelSet) element.eResource().getResourceSet();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (null != modelSet) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("result = new org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand(modelSet.getTransactionalEditingDomain(), (org.eclipse.uml2.uml.NamedElement) element, (String) value, null));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null != result ? result : super.getModificationCommand(element, feature, value);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*            {@inheritDoc}");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @see org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.parsers.AbstractAttributeParser#getValue(org.eclipse.emf.ecore.EObject, org.eclipse.emf.ecore.EStructuralFeature)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("protected Object getValue(final org.eclipse.emf.ecore.EObject element, final org.eclipse.emf.ecore.EStructuralFeature feature) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object result = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(element instanceof org.eclipse.uml2.uml.NamedElement && feature.equals(org.eclipse.uml2.uml.UMLPackage.eINSTANCE.getNamedElement_Name())){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils.getInternationalizationPreference(element) && null != org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement)element)) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("result = UMLLabelInternationalization.getInstance().getLabelWithoutUML((org.eclipse.uml2.uml.NamedElement)element);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null != result ? result : super.getValue(element, feature);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence fields(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if ((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.MESSAGE_FORMAT) || Objects.equals(it.getViewMethod(), LabelTextAccessMethod.PRINTF))) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private String defaultPattern;");
        _builder.newLine();
      }
    }
    {
      if ((((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.MESSAGE_FORMAT) || Objects.equals(it.getViewMethod(), LabelTextAccessMethod.PRINTF)) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.MESSAGE_FORMAT)) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.PRINTF))) {
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        _builder.append("private String defaultEditablePattern;");
        _builder.newLine();
      }
    }
    {
      LabelTextAccessMethod _viewMethod = it.getViewMethod();
      boolean _equals = Objects.equals(_viewMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.text.MessageFormat viewProcessor;");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.text.MessageFormat editorProcessor;");
        _builder.newLine();
      }
    }
    {
      LabelTextAccessMethod _editMethod = it.getEditMethod();
      boolean _equals_1 = Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals_1) {
        _builder.newLine();
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_4);
        _builder.newLineIfNotEmpty();
        _builder.append("private java.text.MessageFormat editProcessor;");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence constructor(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.emf.ecore.EAttribute[] features) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(features);");
    _builder.newLine();
    {
      if ((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.NATIVE) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.NATIVE))) {
        _builder.append("if (features.length != 1) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new IllegalArgumentException(java.util.Arrays.toString(features));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1);
    _builder.append("(org.eclipse.emf.ecore.EAttribute[] features, org.eclipse.emf.ecore.EAttribute[] editableFeatures) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(features, editableFeatures);");
    _builder.newLine();
    {
      if ((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.NATIVE) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.NATIVE))) {
        _builder.append("if (features.length != 1) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new IllegalArgumentException(java.util.Arrays.toString(features));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("if (editableFeatures.length != 1) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("throw new IllegalArgumentException(java.util.Arrays.toString(editableFeatures));");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence aux_methods(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      LabelTextAccessMethod _viewMethod = it.getViewMethod();
      boolean _equals = Objects.equals(_viewMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected String getDefaultPattern() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (defaultPattern == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("StringBuffer sb = new StringBuffer();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (int i = 0; i < features.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (i > 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("sb.append(\' \');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'{\');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(i);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'}\');");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("defaultPattern = sb.toString();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return defaultPattern;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it.getHolder().getEditorGen().getDiagram());
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public void setViewPattern(String viewPattern) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.setViewPattern(viewPattern);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("viewProcessor = null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it.getHolder().getEditorGen().getDiagram());
        _builder.append(_overrideC_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public void setEditorPattern(String editorPattern) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.setEditorPattern(editorPattern);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("editorProcessor = null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_3);
        _builder.newLineIfNotEmpty();
        _builder.append("protected java.text.MessageFormat getViewProcessor() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (viewProcessor == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("viewProcessor = new java.text.MessageFormat(getViewPattern() == null ? getDefaultPattern() : getViewPattern());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return viewProcessor;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_4);
        _builder.newLineIfNotEmpty();
        _builder.append("protected java.text.MessageFormat getEditorProcessor() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (editorProcessor == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("editorProcessor = new java.text.MessageFormat(getEditorPattern() == null ? getDefaultEditablePattern() : getEditorPattern());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return editorProcessor;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _viewMethod_1 = it.getViewMethod();
        boolean _equals_1 = Objects.equals(_viewMethod_1, LabelTextAccessMethod.PRINTF);
        if (_equals_1) {
          CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
          _builder.append(_generatedMemberComment_5);
          _builder.newLineIfNotEmpty();
          _builder.append("protected String getDefaultPattern() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("if (defaultPattern == null) {");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("StringBuffer sb = new StringBuffer();");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("for (int i = 0; i < features.length; i++) {");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("if (i > 0) {");
          _builder.newLine();
          _builder.append("\t\t\t\t");
          _builder.append("sb.append(\' \');");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("sb.append(\'%\');");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("sb.append(i + 1);");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("sb.append(\'$\');");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("sb.append(\'s\');");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("defaultPattern = sb.toString();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return defaultPattern;");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
        }
      }
    }
    {
      if ((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.MESSAGE_FORMAT) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.MESSAGE_FORMAT))) {
        CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_6);
        _builder.newLineIfNotEmpty();
        _builder.append("protected String getDefaultEditablePattern() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (defaultEditablePattern == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("StringBuffer sb = new StringBuffer();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (int i = 0; i < editableFeatures.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (i > 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("sb.append(\' \');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'{\');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(i);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'}\');");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("defaultEditablePattern = sb.toString();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return defaultEditablePattern;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      if ((Objects.equals(it.getViewMethod(), LabelTextAccessMethod.PRINTF) || Objects.equals(it.getEditMethod(), LabelTextAccessMethod.PRINTF))) {
        CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_7);
        _builder.newLineIfNotEmpty();
        _builder.append("protected String getDefaultEditablePattern() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (defaultEditablePattern == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("StringBuffer sb = new StringBuffer();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (int i = 0; i < editableFeatures.length; i++) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (i > 0) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("sb.append(\' \');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'%\');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(i + 1);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'$\');");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("sb.append(\'s\');");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("defaultEditablePattern = sb.toString();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return defaultEditablePattern;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      LabelTextAccessMethod _editMethod = it.getEditMethod();
      boolean _equals_2 = Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals_2) {
        CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_8);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it.getHolder().getEditorGen().getDiagram());
        _builder.append(_overrideC_2);
        _builder.newLineIfNotEmpty();
        _builder.append("public void setEditPattern(String editPattern) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.setEditPattern(editPattern);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("editProcessor = null;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_9);
        _builder.newLineIfNotEmpty();
        _builder.append("protected java.text.MessageFormat getEditProcessor() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (editProcessor == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("editProcessor = new java.text.MessageFormat(getEditPattern() == null ? getDefaultEditablePattern() : getEditPattern());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return editProcessor;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _editMethod_1 = it.getEditMethod();
        boolean _equals_3 = Objects.equals(_editMethod_1, LabelTextAccessMethod.REGEXP);
        if (_equals_3) {
          CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
          _builder.append(_generatedMemberComment_10);
          _builder.newLineIfNotEmpty();
          CharSequence _overrideI = this._codeStyle.overrideI(it.getHolder().getEditorGen().getDiagram());
          _builder.append(_overrideI);
          _builder.newLineIfNotEmpty();
          _builder.append("public String getEditPattern() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("String pattern = super.getEditPattern();");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("return pattern != null ? pattern : \" \"; ");
          CharSequence _nonNLS = this._common.nonNLS(1);
          _builder.append(_nonNLS, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("}");
          _builder.newLine();
        }
      }
    }
    return _builder;
  }

  public CharSequence parser_getEditStringMethod(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it.getHolder().getEditorGen().getDiagram());
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getEditString(org.eclipse.core.runtime.IAdaptable adapter, int flags) {");
    _builder.newLine();
    {
      LabelTextAccessMethod _viewMethod = it.getViewMethod();
      boolean _equals = Objects.equals(_viewMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        _builder.append("org.eclipse.emf.ecore.EObject element =\tadapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
        _builder.newLine();
        _builder.append("return getEditorProcessor().format(getEditableValues(element), new StringBuffer(), new java.text.FieldPosition(0)).toString();");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _viewMethod_1 = it.getViewMethod();
        boolean _equals_1 = Objects.equals(_viewMethod_1, LabelTextAccessMethod.PRINTF);
        if (_equals_1) {
          _builder.append("org.eclipse.emf.ecore.EObject element = adapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
          _builder.newLine();
          _builder.append("String pattern = getEditorPattern() == null ? getDefaultEditablePattern() : getEditorPattern();");
          _builder.newLine();
          _builder.append("return String.format(pattern, getEditableValues(element));");
          _builder.newLine();
        } else {
          LabelTextAccessMethod _viewMethod_2 = it.getViewMethod();
          boolean _equals_2 = Objects.equals(_viewMethod_2, LabelTextAccessMethod.REGEXP);
          if (_equals_2) {
            _builder.append("return \"\"; ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append(_nonNLS);
            _builder.newLineIfNotEmpty();
          } else {
            LabelTextAccessMethod _viewMethod_3 = it.getViewMethod();
            boolean _equals_3 = Objects.equals(_viewMethod_3, LabelTextAccessMethod.NATIVE);
            if (_equals_3) {
              _builder.append("org.eclipse.emf.ecore.EObject element = adapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
              _builder.newLine();
              _builder.append("String s = org.eclipse.emf.ecore.util.EcoreUtil.convertToString(editableFeatures[0].getEAttributeType(), element.eGet(editableFeatures[0]));");
              _builder.newLine();
              _builder.append("return s != null ? s : \"\"; ");
              CharSequence _nonNLS_1 = this._common.nonNLS(1);
              _builder.append(_nonNLS_1);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parser_isValidEditStringMethod(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it.getHolder().getEditorGen().getDiagram());
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus isValidEditString(org.eclipse.core.runtime.IAdaptable adapter, String editString) {");
    _builder.newLine();
    {
      LabelTextAccessMethod _editMethod = it.getEditMethod();
      boolean _equals = Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        _builder.append("java.text.ParsePosition pos = new java.text.ParsePosition(0);");
        _builder.newLine();
        _builder.append("Object[] values = getEditProcessor().parse(editString, pos);");
        _builder.newLine();
        _builder.append("if (values == null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus(");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getHolder().getEditorGen().getPlugin());
        _builder.append(_qualifiedClassName, "\t");
        _builder.append(".ID, org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus.UNEDITABLE, org.eclipse.osgi.util.NLS.bind(");
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getHolder().getEditorGen(), this.i18nKeyForMessageFormatParserInvalidInputError());
        _builder.append(_accessorCall, "\t");
        _builder.append(", pos.getErrorIndex()));");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return validateNewValues(values);");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _editMethod_1 = it.getEditMethod();
        boolean _equals_1 = Objects.equals(_editMethod_1, LabelTextAccessMethod.PRINTF);
        if (_equals_1) {
          _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.UNEDITABLE_STATUS;");
          _builder.newLine();
        } else {
          LabelTextAccessMethod _editMethod_2 = it.getEditMethod();
          boolean _equals_2 = Objects.equals(_editMethod_2, LabelTextAccessMethod.REGEXP);
          if (_equals_2) {
            _builder.append("if (editString == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.UNEDITABLE_STATUS;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("Object[] values = editString.split(getEditPattern());");
            _builder.newLine();
            _builder.append("return validateNewValues(values);");
            _builder.newLine();
          } else {
            LabelTextAccessMethod _editMethod_3 = it.getEditMethod();
            boolean _equals_3 = Objects.equals(_editMethod_3, LabelTextAccessMethod.NATIVE);
            if (_equals_3) {
              _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.EDITABLE_STATUS;");
              _builder.newLine();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parser_getParseCommandMethod(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it.getHolder().getEditorGen().getDiagram());
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.core.command.ICommand getParseCommand(org.eclipse.core.runtime.IAdaptable adapter, String newString, int flags) {");
    _builder.newLine();
    {
      LabelTextAccessMethod _editMethod = it.getEditMethod();
      boolean _equals = Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        _builder.append("Object[] values = getEditProcessor().parse(newString, new java.text.ParsePosition(0));");
        _builder.newLine();
        _builder.append("return getParseCommand(adapter, values, flags);");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _editMethod_1 = it.getEditMethod();
        boolean _equals_1 = Objects.equals(_editMethod_1, LabelTextAccessMethod.PRINTF);
        if (_equals_1) {
          _builder.append("return org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand.INSTANCE;");
          _builder.newLine();
        } else {
          LabelTextAccessMethod _editMethod_2 = it.getEditMethod();
          boolean _equals_2 = Objects.equals(_editMethod_2, LabelTextAccessMethod.REGEXP);
          if (_equals_2) {
            _builder.append("if (newString == null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand.INSTANCE;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("Object[] values = newString.split(getEditPattern());");
            _builder.newLine();
            _builder.append("return super.getParseCommand(adapter, values, flags);");
            _builder.newLine();
          } else {
            LabelTextAccessMethod _editMethod_3 = it.getEditMethod();
            boolean _equals_3 = Objects.equals(_editMethod_3, LabelTextAccessMethod.NATIVE);
            if (_equals_3) {
              _builder.append("Object value = org.eclipse.emf.ecore.util.EcoreUtil.createFromString(editableFeatures[0].getEAttributeType(), newString);");
              _builder.newLine();
              _builder.append("return getParseCommand(adapter, new Object[] { value }, flags);");
              _builder.newLine();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence parser_getPrintStringMethod(final org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it.getHolder().getEditorGen().getDiagram());
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getPrintString(org.eclipse.core.runtime.IAdaptable adapter, int flags) {");
    _builder.newLine();
    {
      LabelTextAccessMethod _viewMethod = it.getViewMethod();
      boolean _equals = Objects.equals(_viewMethod, LabelTextAccessMethod.MESSAGE_FORMAT);
      if (_equals) {
        _builder.append("org.eclipse.emf.ecore.EObject element = adapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
        _builder.newLine();
        _builder.append("return getViewProcessor().format(getValues(element), new StringBuffer(), new java.text.FieldPosition(0)).toString();");
        _builder.newLine();
      } else {
        LabelTextAccessMethod _viewMethod_1 = it.getViewMethod();
        boolean _equals_1 = Objects.equals(_viewMethod_1, LabelTextAccessMethod.PRINTF);
        if (_equals_1) {
          _builder.append("org.eclipse.emf.ecore.EObject element = adapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
          _builder.newLine();
          _builder.append("return String.format(getViewPattern() == null ? getDefaultPattern() : getViewPattern(), getValues(element));");
          _builder.newLine();
        } else {
          LabelTextAccessMethod _viewMethod_2 = it.getViewMethod();
          boolean _equals_2 = Objects.equals(_viewMethod_2, LabelTextAccessMethod.REGEXP);
          if (_equals_2) {
            _builder.append("return \"\"; ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append(_nonNLS);
            _builder.newLineIfNotEmpty();
          } else {
            LabelTextAccessMethod _viewMethod_3 = it.getViewMethod();
            boolean _equals_3 = Objects.equals(_viewMethod_3, LabelTextAccessMethod.NATIVE);
            if (_equals_3) {
              _builder.append("org.eclipse.emf.ecore.EObject element = adapter.getAdapter(org.eclipse.emf.ecore.EObject.class);");
              _builder.newLine();
              _builder.append("String s = org.eclipse.emf.ecore.util.EcoreUtil.convertToString(features[0].getEAttributeType(), element.eGet(features[0]));");
              _builder.newLine();
              _builder.append("return s != null ? s : \"\"; ");
              CharSequence _nonNLS_1 = this._common.nonNLS(1);
              _builder.append(_nonNLS_1);
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence i18nValues(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenParserImplementation> _implementations = it.getImplementations();
      boolean _tripleNotEquals = (_implementations != null);
      if (_tripleNotEquals) {
        {
          final Function1<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser, Boolean> _function = (org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser p) -> {
            LabelTextAccessMethod _editMethod = p.getEditMethod();
            return Boolean.valueOf(Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT));
          };
          boolean _exists = IterableExtensions.<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser>exists(Iterables.<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser>filter(it.getImplementations(), org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser.class), _function);
          if (_exists) {
            CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForMessageFormatParserInvalidInputError(), "Invalid input at {0}");
            _builder.append(_messageEntry);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  public CharSequence i18nAccessors(final GenParsers it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<GenParserImplementation> _implementations = it.getImplementations();
      boolean _tripleNotEquals = (_implementations != null);
      if (_tripleNotEquals) {
        {
          final Function1<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser, Boolean> _function = (org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser p) -> {
            LabelTextAccessMethod _editMethod = p.getEditMethod();
            return Boolean.valueOf(Objects.equals(_editMethod, LabelTextAccessMethod.MESSAGE_FORMAT));
          };
          boolean _exists = IterableExtensions.<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser>exists(Iterables.<org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser>filter(it.getImplementations(), org.eclipse.papyrus.gmf.codegen.gmfgen.PredefinedParser.class), _function);
          if (_exists) {
            CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForMessageFormatParserInvalidInputError());
            _builder.append(_accessorField);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  @Localization
  protected String i18nKeyForMessageFormatParserInvalidInputError() {
    return "MessageFormatParser.InvalidInputError";
  }
}
