/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 missing @override
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class NodeEditPart {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private Utils_qvto _utils_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private impl.diagram.editparts.NodeEditPart xptNodeEditPartImpl;

  @Inject
  private xpt.diagram.editparts.Common xptCommon;

  public CharSequence qualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.xptNodeEditPartImpl.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.xptNodeEditPartImpl.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence Main(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.xptNodeEditPartImpl.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.xptNodeEditPartImpl.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.xptNodeEditPartImpl.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createLayoutEditPolicy = this.xptNodeEditPartImpl.createLayoutEditPolicy(it);
    _builder.append(_createLayoutEditPolicy, "\t");
    _builder.newLineIfNotEmpty();
    CharSequence _specificHandleNotificationEvent = this.xptNodeEditPartImpl.specificHandleNotificationEvent(it);
    _builder.append(_specificHandleNotificationEvent);
    _builder.newLineIfNotEmpty();
    CharSequence _createNodeShape = this.xptNodeEditPartImpl.createNodeShape(it.getViewmap(), it);
    _builder.append(_createNodeShape);
    _builder.newLineIfNotEmpty();
    {
      boolean _hasFixedChildren = this._utils_qvto.hasFixedChildren(it);
      if (_hasFixedChildren) {
        _builder.append("\t");
        CharSequence _addFixedChild = this.xptNodeEditPartImpl.addFixedChild(it);
        _builder.append(_addFixedChild, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _removeFixedChild = this.xptNodeEditPartImpl.removeFixedChild(it);
        _builder.append(_removeFixedChild, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _addChildVisual = this.xptNodeEditPartImpl.addChildVisual(it);
        _builder.append(_addChildVisual, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _removeChildVisual = this.xptNodeEditPartImpl.removeChildVisual(it);
        _builder.append(_removeChildVisual, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _contentPaneFor = this.xptNodeEditPartImpl.getContentPaneFor(it);
        _builder.append(_contentPaneFor, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _addBorderItem = this.xptNodeEditPartImpl.addBorderItem(it);
    _builder.append(_addBorderItem, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createNodePlate = this.xptNodeEditPartImpl.createNodePlate(it);
    _builder.append(_createNodePlate, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _primaryDragEditPolicy = this.xptNodeEditPartImpl.getPrimaryDragEditPolicy(it);
    _builder.append(_primaryDragEditPolicy, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createFigure = this.xptNodeEditPartImpl.createFigure(it);
    _builder.append(_createFigure, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setupContentPane = this.xptNodeEditPartImpl.setupContentPane(it);
    _builder.append(_setupContentPane, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _contentPane = this.xptNodeEditPartImpl.getContentPane(it);
    _builder.append(_contentPane, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setForegroundColor = this.xptNodeEditPartImpl.setForegroundColor(it);
    _builder.append(_setForegroundColor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setLineWidth = this.xptNodeEditPartImpl.setLineWidth(it);
    _builder.append(_setLineWidth, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _setLineStyle = this.xptNodeEditPartImpl.setLineStyle(it);
    _builder.append(_setLineStyle, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _primaryChildEditPart = this.xptNodeEditPartImpl.getPrimaryChildEditPart(it);
    _builder.append(_primaryChildEditPart, "\t");
    _builder.newLineIfNotEmpty();
    {
      boolean _hasChildrenInListCompartments = this._utils_qvto.hasChildrenInListCompartments(it);
      if (_hasChildrenInListCompartments) {
        _builder.append("\t");
        CharSequence _targetEditPartMethod = this.xptNodeEditPartImpl.getTargetEditPartMethod(it);
        _builder.append(_targetEditPartMethod, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _handleNotificationEvent = this.handleNotificationEvent(it);
    _builder.append(_handleNotificationEvent, "\t");
    _builder.newLineIfNotEmpty();
    CharSequence _innerClassDeclaration = this.xptNodeEditPartImpl.innerClassDeclaration(it.getViewmap());
    _builder.append(_innerClassDeclaration);
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence extendsList(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends ");
    CharSequence _extendsListContents = this.xptNodeEditPartImpl.extendsListContents(it);
    _builder.append(_extendsListContents);
    return _builder;
  }

  public CharSequence attributes(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure contentPane;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.draw2d.IFigure primaryShape;");
    _builder.newLine();
    return _builder;
  }

  public CharSequence createDefaultEditPolicies(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPoliciesBody = this.xptNodeEditPartImpl.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  protected CharSequence _handleNotificationEvent(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  protected CharSequence _handleNotificationEvent(final GenTopLevelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      boolean _generateShortcutIcon = it.getDiagram().generateShortcutIcon();
      if (_generateShortcutIcon) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _handleNotificationEventBody = this.xptNodeEditPartImpl.handleNotificationEventBody(it);
        _builder.append(_handleNotificationEventBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence handleNotificationEvent(final GenNode it) {
    if (it instanceof GenTopLevelNode) {
      return _handleNotificationEvent((GenTopLevelNode)it);
    } else if (it != null) {
      return _handleNotificationEvent(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
