/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.infra.tools.util.XMLTreeIterator;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BasicEMFResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BasicPluginXMLResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.messages.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface OpaqueResourceProvider<E, P extends OpaqueResourceProvider<E, P>> {
    public Iterable<ClassifiedURI> getOpaqueResourceReferences(IProject var1, IFile var2, E var3, DiagnosticChain var4, Map<Object, Object> var5);

    default public OpaqueResourceProvider<E, P> and(P other) {
        return other == null ? this : (modelProject, modelFile, object, diagnostics, context) -> Iterables.concat(this.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context), other.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context));
    }

    default public <V> void process(IProject modelProject, IFile modelFile, Stream<E> content, DiagnosticChain diagnostics, Function<? super ClassifiedURI, V> existingURITransform, Consumer<? super V> acceptor) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        EValidator.SubstitutionLabelProvider labels = ModelValidationChecker.createSubstitutionLabelProvider((AdapterFactory)adapterFactory);
        try {
            HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider> context = new HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider>();
            context.put(EValidator.SubstitutionLabelProvider.class, labels);
            content.map(object -> this.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context)).filter(Predicate.not(Iterables::isEmpty)).map(Iterable::spliterator).flatMap(uris -> StreamSupport.stream(uris, false)).distinct().map(existingURITransform).forEach(acceptor);
        }
        finally {
            adapterFactory.dispose();
        }
    }

    public static <E, P extends OpaqueResourceProvider<E, P>> P and(P provider, P other) {
        return (P)(provider == null ? other : (other == null ? provider : provider.and(other)));
    }

    public static interface ClassifiedURI {
        public static final Object DEFAULT_CLASSIFIER = ResourceKind.GENERIC;

        public URI uri();

        public Object classifier();
    }

    @FunctionalInterface
    public static interface EMF
    extends OpaqueResourceProvider<EObject, EMF> {
        default public void processModel(IProject modelProject, IFile modelFile, Resource modelResource, DiagnosticChain diagnostics, Consumer<? super ClassifiedURI> existingURIAcceptor) {
            this.processModel(modelProject, modelFile, modelResource, diagnostics, Function.identity(), existingURIAcceptor);
        }

        default public <V> void processModel(IProject modelProject, IFile modelFile, Resource modelResource, DiagnosticChain diagnostics, Function<? super ClassifiedURI, V> existingURITransform, Consumer<? super V> acceptor) {
            this.process(modelProject, modelFile, Iterators2.stream((TreeIterator)modelResource.getAllContents()), diagnostics, existingURITransform, acceptor);
        }

        default public EMF and(EMF other) {
            return (modelProject, modelFile, object, diagnostics, context) -> Iterables.concat(this.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context), other.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context));
        }

        public static EMF create(Object classifier, String diagnosticSource, EAttribute attribute) {
            return new BasicEMFResourceProvider(classifier, diagnosticSource, attribute);
        }

        public static EMF create(Object classifier, String diagnosticSource, EAttribute attribute, EAttribute bundleQualifier) {
            return new BasicEMFResourceProvider(classifier, diagnosticSource, attribute, bundleQualifier);
        }

        public static <V> EMF create(Object classifier, String diagnosticSource, EAttribute attribute, URIAccessor<EObject, EAttribute, V> uriAccessor) {
            return new BasicEMFResourceProvider(classifier, diagnosticSource, attribute, uriAccessor);
        }

        public static <V> EMF create(Object classifier, String diagnosticSource, EAttribute attribute, EAttribute bundleQualifier, URIAccessor<EObject, EAttribute, V> uriAccessor) {
            return new BasicEMFResourceProvider(classifier, diagnosticSource, attribute, bundleQualifier, uriAccessor);
        }
    }

    public static enum ResourceKind {
        GENERIC(Messages.ResourceKind_0),
        ICON(Messages.ResourceKind_1),
        CLASS(Messages.ResourceKind_2),
        METAMODEL(Messages.ResourceKind_3);

        private final String localName;

        private ResourceKind(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }
    }

    @FunctionalInterface
    public static interface URIAccessor<E, A, T> {
        public URI getURI(E var1, A var2, T var3);
    }

    @FunctionalInterface
    public static interface XML
    extends OpaqueResourceProvider<Element, XML> {
        default public void processPluginXML(IProject modelProject, IFile pluginXML, DiagnosticChain diagnostics, Consumer<? super ClassifiedURI> existingURIAcceptor) {
            this.processModel(modelProject, pluginXML, diagnostics, Function.identity(), existingURIAcceptor);
        }

        default public <V> void processModel(IProject modelProject, IFile pluginXML, DiagnosticChain diagnostics, Function<? super ClassifiedURI, V> existingURITransform, Consumer<? super V> acceptor) {
            try {
                Document doc;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Throwable throwable = null;
                Object var10_11 = null;
                try (InputStream content = pluginXML.getContents();){
                    doc = builder.parse(content, String.valueOf(pluginXML.getLocation()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.process(modelProject, pluginXML, Iterators2.stream((TreeIterator)new XMLTreeIterator(doc)), diagnostics, existingURITransform, acceptor);
            }
            catch (Exception e) {
                Activator.log.error("Failed to parse the plugin.xml file.", (Throwable)e);
            }
        }

        default public XML and(XML other) {
            return (modelProject, modelFile, object, diagnostics, context) -> Iterables.concat(this.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context), other.getOpaqueResourceReferences(modelProject, modelFile, object, diagnostics, context));
        }

        public static XML create(Object classifier, String diagnosticSource, String extensionPoint, String element, String attribute) {
            return new BasicPluginXMLResourceProvider(classifier, diagnosticSource, extensionPoint, element, attribute);
        }

        public static XML create(Object classifier, String diagnosticSource, String extensionPoint, String element, String attribute, URIAccessor<Element, String, String> uriAccessor) {
            return new BasicPluginXMLResourceProvider(classifier, diagnosticSource, extensionPoint, element, attribute, uriAccessor);
        }
    }
}

