/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.p2.impl.MetadataRepositoryImpl;
import org.eclipse.cbi.p2repo.p2.loader.IRepositoryLoader;
import org.eclipse.cbi.p2repo.p2.util.ResourceSetWithAgent;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.cbi.p2repo.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.equinox.p2.core.IProvisioningAgent;

public class P2ResourceImpl
extends XMLResourceImpl {
    private AsynchronousLoader asynchronousLoader;
    private IRepositoryLoader loader;
    private final Object lock = new Object();
    private Job loaderJob;

    public P2ResourceImpl(URI uri) {
        throw new IllegalArgumentException("Use constructor with loader");
    }

    public P2ResourceImpl(URI uri, IRepositoryLoader loader) {
        super(uri);
        this.loader = loader;
    }

    public synchronized void cancelLoadingJob() {
        if (this.loaderJob != null) {
            this.loaderJob.cancel();
        }
    }

    private java.net.URI getLocationFromURI(URI uri) throws URISyntaxException {
        String opaquePart = uri.opaquePart();
        int pos = opaquePart.indexOf(58);
        return new java.net.URI(opaquePart.substring(pos + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map<?, ?> options) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLoaded) {
                return;
            }
            if (!this.isLoading) {
                this.isLoading = true;
                if (this.errors == null) {
                    this.errors = new BasicEList();
                }
                if (this.warnings == null) {
                    this.warnings = new BasicEList();
                }
                this.errors.clear();
                this.warnings.clear();
                try {
                    ResourceSet resourceSet = this.getResourceSet();
                    IProvisioningAgent agent = null;
                    if (resourceSet instanceof ResourceSetWithAgent) {
                        agent = ((ResourceSetWithAgent)resourceSet).getProvisioningAgent();
                    }
                    this.loaderJob = new LoaderJob(agent, "Loading repository " + this.getURI().opaquePart(), this.getLocationFromURI(this.getURI()));
                    this.loaderJob.setUser(false);
                    this.loaderJob.schedule();
                }
                catch (URISyntaxException e) {
                    this.isLoading = false;
                    this.isLoaded = false;
                    IOException ex = new IOException();
                    ex.initCause(e);
                    throw ex;
                }
            }
        }
        try {
            this.loaderJob.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void save(Map<?, ?> options) {
    }

    public synchronized void startAsynchronousLoad() {
        if (this.isLoaded() && !this.isLoading()) {
            return;
        }
        AsynchronousLoader lastLoader = this.asynchronousLoader;
        if (lastLoader == null) {
            this.asynchronousLoader = new AsynchronousLoader("Loading " + this.getURI().opaquePart(), lastLoader);
            this.asynchronousLoader.setUser(false);
            this.asynchronousLoader.schedule();
        }
    }

    class AsynchronousLoader
    extends Job {
        private Job replaceJob;

        public AsynchronousLoader(String name, Job replaceJob) {
            super(name);
            this.replaceJob = replaceJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            class MonitorWatchDog
            extends Thread {
                private boolean done;
                private final /* synthetic */ IProgressMonitor val$monitor;

                MonitorWatchDog(IProgressMonitor iProgressMonitor) {
                    this.val$monitor = iProgressMonitor;
                }

                @Override
                public void run() {
                    while (!this.done) {
                        if (this.val$monitor.isCanceled()) {
                            P2ResourceImpl.this.cancelLoadingJob();
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }

                public void setDone() {
                    this.done = true;
                }
            }
            MonitorWatchDog watchDog = new MonitorWatchDog(monitor);
            try {
                if (this.replaceJob != null) {
                    this.replaceJob.cancel();
                    this.replaceJob.join();
                }
                watchDog.start();
                IStatus status = Status.OK_STATUS;
                try {
                    P2ResourceImpl.this.load(null);
                }
                catch (IOException e) {
                    status = new Status(4, "org.eclipse.cbi.p2repo.p2", "Unable to load repository " + P2ResourceImpl.this.getURI().opaquePart(), (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                }
                iStatus = status;
            }
            catch (InterruptedException interruptedException) {
                try {
                    throw new RuntimeException("Repository load was interrupted");
                }
                catch (Throwable throwable) {
                    monitor.done();
                    watchDog.setDone();
                    P2ResourceImpl p2ResourceImpl = P2ResourceImpl.this;
                    synchronized (p2ResourceImpl) {
                        if (P2ResourceImpl.this.asynchronousLoader == this) {
                            P2ResourceImpl.this.asynchronousLoader = null;
                        }
                    }
                    throw throwable;
                }
            }
            monitor.done();
            watchDog.setDone();
            P2ResourceImpl p2ResourceImpl = P2ResourceImpl.this;
            synchronized (p2ResourceImpl) {
                if (P2ResourceImpl.this.asynchronousLoader == this) {
                    P2ResourceImpl.this.asynchronousLoader = null;
                }
            }
            return iStatus;
        }
    }

    private class LoaderJob
    extends Job {
        private IProvisioningAgent agent;
        private java.net.URI location;

        public LoaderJob(IProvisioningAgent agent, String name, java.net.URI location) {
            super(name);
            this.location = null;
            this.agent = agent;
            this.location = location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            block20: {
                String msg = String.format("Loading repository %s", this.location);
                try {
                    try {
                        MetadataRepositoryImpl repository = (MetadataRepositoryImpl)P2Factory.eINSTANCE.createMetadataRepository();
                        P2ResourceImpl.this.loader.open(this.location, this.agent, repository);
                        LogUtils.debug((String)msg, (Object[])new Object[0]);
                        long start = TimeUtils.getNow();
                        P2ResourceImpl.this.loader.load(monitor);
                        P2ResourceImpl.this.getContents().add((Object)repository);
                        LogUtils.debug((String)"Repository %s loaded (Took %s)", (Object[])new Object[]{this.location, TimeUtils.getFormattedDuration((long)start)});
                    }
                    catch (Exception e) {
                        LogUtils.error((Throwable)e, (String)"Unable to load repository %s", (Object[])new Object[]{this.location});
                        P2ResourceImpl.this.errors.add((Object)new Resource.Diagnostic(){

                            public int getColumn() {
                                return 0;
                            }

                            public int getLine() {
                                return 0;
                            }

                            public String getLocation() {
                                return LoaderJob.this.location.toString();
                            }

                            public String getMessage() {
                                return e.getMessage();
                            }
                        });
                        Object object = P2ResourceImpl.this.lock;
                        synchronized (object) {
                            P2ResourceImpl.this.setLoaded(true);
                            P2ResourceImpl.this.isLoading = false;
                        }
                        try {
                            P2ResourceImpl.this.loader.close();
                        }
                        catch (CoreException e2) {
                            LogUtils.error((Throwable)e2, (String)"Unable to close repository loader for %s", (Object[])new Object[]{this.location});
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    Object e2 = P2ResourceImpl.this.lock;
                    synchronized (e2) {
                        P2ResourceImpl.this.setLoaded(true);
                        P2ResourceImpl.this.isLoading = false;
                    }
                    try {
                        P2ResourceImpl.this.loader.close();
                    }
                    catch (CoreException e22) {
                        LogUtils.error((Throwable)e22, (String)"Unable to close repository loader for %s", (Object[])new Object[]{this.location});
                    }
                    throw throwable;
                }
                Object e22 = P2ResourceImpl.this.lock;
                synchronized (e22) {
                    P2ResourceImpl.this.setLoaded(true);
                    P2ResourceImpl.this.isLoading = false;
                }
                try {
                    P2ResourceImpl.this.loader.close();
                }
                catch (CoreException e) {
                    LogUtils.error((Throwable)e, (String)"Unable to close repository loader for %s", (Object[])new Object[]{this.location});
                }
            }
            return Status.OK_STATUS;
        }
    }
}

