/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.Assert;

public class ProjectUtils {
    private ProjectUtils() {
    }

    public static final IProject createProject(String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject(projectName);
        if (testProject.exists()) {
            testProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)testProject);
        return testProject;
    }

    public static final void removeAllProjectFromTheWorkspace() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }
}

