/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.validation;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class DependencyValidationUtils {
    public static final String MISSING_DEPENDENCIES = "Missing Dependencies";
    public static final String DEPENDENCY_SEPARATOR = ",";

    private DependencyValidationUtils() {
    }

    public static final Diagnostic createMissingDependenciesDiagnostic(EObject eobjectInError, EStructuralFeature feature, Collection<String> missingDependencies) {
        StringBuilder missingDependenciesBuilder = new StringBuilder();
        Iterator<String> iter = missingDependencies.iterator();
        while (iter.hasNext()) {
            missingDependenciesBuilder.append(iter.next());
            if (!iter.hasNext()) continue;
            missingDependenciesBuilder.append(DEPENDENCY_SEPARATOR);
        }
        Object[] data = new String[]{MISSING_DEPENDENCIES, eobjectInError.eClass().getName(), feature.getName(), missingDependencies.toString()};
        String message = NLS.bind((String)"{0} : The field {1}#{2} required to add the dependencies {3} in the Manifest file", (Object[])data);
        BasicDiagnostic bDiag = new BasicDiagnostic(4, "org.eclipse.emf.ecore", 1, message, new Object[]{eobjectInError});
        return bDiag;
    }
}

