/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.locator;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.LabelLocator;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class SelfMessageLabelLocator
extends LabelLocator {
    private static final int H_MARGIN = 4;

    public SelfMessageLabelLocator(IFigure parent, int alignment) {
        super(parent, new Point(), alignment);
    }

    public void relocate(IFigure target) {
        Dimension size = target.getPreferredSize();
        boolean relocated = false;
        PointList points = ((Connection)this.parent).getPoints();
        List lineSegments = PointListUtilities.getLineSegments((PointList)points);
        if (lineSegments.size() == 3) {
            Point start = points.getFirstPoint();
            LineSeg center = (LineSeg)lineSegments.get(1);
            if (center.isVertical()) {
                Point origin = center.getOrigin();
                Point terminus = center.getTerminus();
                Point loc = new Point(origin.x, -1);
                loc.y = origin.x < terminus.x ? origin.y + (terminus.y - origin.y) / 2 : terminus.y + (origin.y - terminus.y) / 2;
                Rectangle rect = new Rectangle(loc, size);
                if (start.x < loc.x) {
                    rect.translate(4, -1 * size.height / 2);
                } else {
                    rect.translate(-4 - size.width, -1 * size.height / 2);
                }
                target.setBounds(rect);
                relocated = true;
            }
        }
        if (!relocated) {
            super.relocate(target);
        }
    }
}

