/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeRegistryListener;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.IModelingAssistantModelProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.AssistantPlugin;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.DefaultModelingAssistantModelProvider;
import org.eclipse.uml2.common.util.CacheAdapter;

public class ModelingAssistantModelRegistry
implements IProviderChangeListener {
    private static final String EXT_POINT = "modelProviders";
    private static final String E_PROVIDER = "modelProvider";
    private static final String A_URI = "uri";
    private static final String A_CLASS = "class";
    private static final ModelingAssistantModelRegistry INSTANCE = new ModelingAssistantModelRegistry();
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private final Multimap<IModelingAssistantModelProvider, IModelingAssistantProvider> providers = HashMultimap.create();
    private final Multimap<IModelingAssistantModelProvider, Resource> models = HashMultimap.create();
    private final Map<URI, IModelingAssistantModelProvider> workspaceModels = Maps.newHashMap();
    private final CopyOnWriteArrayList<IProviderChangeListener> listeners = new CopyOnWriteArrayList();

    private ModelingAssistantModelRegistry() {
        this.resourceSet.eAdapters().add((Object)new CacheAdapter());
        new ExtensionLoader().readRegistry();
        for (URI next : AssistantPlugin.preferences.getWorkspaceAssistantModels()) {
            this.addWorkspaceModel(next);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.createWorkspaceListener(), 1);
        ElementTypeRegistry.getInstance().addElementTypeRegistryListener(this.createElementTypeRegistryListener());
    }

    public static ModelingAssistantModelRegistry getInstance() {
        return INSTANCE;
    }

    public Iterable<IModelingAssistantProvider> getModelingAssistantProviders() {
        return Collections.unmodifiableCollection(this.providers.values());
    }

    public void loadModels(IModelingAssistantModelProvider modelProvider) {
        EList resources = this.resourceSet.getResources();
        int priors = resources.size();
        this.providers.putAll((Object)modelProvider, modelProvider.loadProviders(this.resourceSet));
        this.models.putAll((Object)modelProvider, resources.subList(priors, resources.size()));
    }

    public void unloadModels(IModelingAssistantModelProvider modelProvider) {
        for (Resource next : this.models.get((Object)modelProvider)) {
            next.unload();
            this.resourceSet.getResources().remove((Object)next);
            next.eAdapters().clear();
        }
        this.models.removeAll((Object)modelProvider);
        this.providers.removeAll((Object)modelProvider);
    }

    public void registerWorkspaceAssistantModel(URI uri) {
        if (!this.workspaceModels.containsKey(uri) && this.addWorkspaceModel(uri)) {
            AssistantPlugin.preferences.addWorkspaceAssistantModel(uri);
        }
    }

    public void deregisterWorkspaceAssistantModel(URI uri) {
        if (this.removeWorkspaceModel(uri)) {
            AssistantPlugin.preferences.removeWorkspaceAssistantModel(uri);
        }
    }

    public boolean isRegistered(URI assistantModelURI) {
        Resource resource = this.resourceSet.getResource(assistantModelURI, false);
        return resource != null && resource.isLoaded();
    }

    private boolean addWorkspaceModel(URI uri) {
        boolean result = this.resourceSet.getURIConverter().exists(uri, null);
        if (result) {
            DefaultModelingAssistantModelProvider provider = new DefaultModelingAssistantModelProvider(uri);
            this.workspaceModels.put(uri, provider);
            this.loadModels(provider);
        }
        return result;
    }

    private boolean removeWorkspaceModel(URI uri) {
        IModelingAssistantModelProvider provider = this.workspaceModels.remove(uri);
        if (provider != null) {
            this.unloadModels(provider);
        }
        return provider != null;
    }

    void reloadWorkspaceModel(URI oldURI, URI newURI) {
        if (oldURI != null) {
            this.removeWorkspaceModel(oldURI);
        }
        if (newURI != null) {
            this.addWorkspaceModel(newURI);
        }
    }

    public void providerChanged(ProviderChangeEvent event) {
        if (!this.listeners.isEmpty()) {
            for (IProviderChangeListener next : this.listeners) {
                try {
                    next.providerChanged(event);
                }
                catch (Exception e) {
                    AssistantPlugin.log.error("Uncaught exception in provider change listener", (Throwable)e);
                }
            }
        }
    }

    public void addProviderChangeListener(IProviderChangeListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeProviderChangeListener(IProviderChangeListener listener) {
        this.listeners.remove(listener);
    }

    private IResourceChangeListener createWorkspaceListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            URI uri;
                            IResource resource = delta.getResource();
                            if (resource.getType() == 1 && AssistantPlugin.preferences.isWorkspaceAssistantModel(uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true))) {
                                switch (delta.getKind()) {
                                    case 4: {
                                        if ((delta.getFlags() & 0x10100) == 0) break;
                                        ModelingAssistantModelRegistry.this.reloadWorkspaceModel(uri, uri);
                                        break;
                                    }
                                    case 2: {
                                        if ((delta.getFlags() & 0x2000) != 0) {
                                            IPath movedToPath = delta.getMovedToPath();
                                            if (movedToPath == null) break;
                                            URI newURI = URI.createPlatformResourceURI((String)movedToPath.toString(), (boolean)true);
                                            ModelingAssistantModelRegistry.this.deregisterWorkspaceAssistantModel(uri);
                                            ModelingAssistantModelRegistry.this.registerWorkspaceAssistantModel(newURI);
                                            break;
                                        }
                                        if (resource.getProject().isAccessible()) {
                                            ModelingAssistantModelRegistry.this.deregisterWorkspaceAssistantModel(uri);
                                            break;
                                        }
                                        ModelingAssistantModelRegistry.this.reloadWorkspaceModel(uri, null);
                                        break;
                                    }
                                    case 1: {
                                        if ((delta.getFlags() & 0x1000) != 0) break;
                                        ModelingAssistantModelRegistry.this.reloadWorkspaceModel(null, uri);
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    AssistantPlugin.log.error((Throwable)e);
                }
            }
        };
    }

    private IElementTypeRegistryListener createElementTypeRegistryListener() {
        return new IElementTypeRegistryListener(){

            public void elementTypeAdded(ElementTypeAddedEvent elementTypeAddedEvent) {
                CacheAdapter.getCacheAdapter((Notifier)ModelingAssistantModelRegistry.this.resourceSet).clear();
            }
        };
    }

    private class ExtensionLoader
    extends RegistryReader {
        private final Map<IConfigurationElement, IModelingAssistantModelProvider> configured;

        ExtensionLoader() {
            super(Platform.getExtensionRegistry(), AssistantPlugin.getPlugin().getSymbolicName(), ModelingAssistantModelRegistry.EXT_POINT);
            this.configured = Maps.newHashMap();
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            boolean result = true;
            switch (element.getName()) {
                case "modelProvider": {
                    if (add) {
                        this.loadModels(element);
                        break;
                    }
                    this.unloadModels(element);
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        private void loadModels(IConfigurationElement element) {
            IModelingAssistantModelProvider provider = null;
            String modelURIString = element.getAttribute(ModelingAssistantModelRegistry.A_URI);
            if (modelURIString != null) {
                URI resourceURI = URI.createURI((String)modelURIString);
                if (resourceURI.isRelative()) {
                    resourceURI = resourceURI.resolve(URI.createPlatformPluginURI((String)(element.getContributor().getName() + "/"), (boolean)true));
                }
                provider = new DefaultModelingAssistantModelProvider(resourceURI);
            } else {
                String className = element.getAttribute(ModelingAssistantModelRegistry.A_CLASS);
                if (className == null) {
                    this.logMissingAttribute(element, ModelingAssistantModelRegistry.A_URI);
                } else {
                    try {
                        provider = (IModelingAssistantModelProvider)element.createExecutableExtension(ModelingAssistantModelRegistry.A_CLASS);
                    }
                    catch (CoreException e) {
                        AssistantPlugin.log.error("Failed to instantiate modeling assistant model provider extension", (Throwable)e);
                    }
                }
            }
            if (provider != null) {
                this.configured.put(element, provider);
                ModelingAssistantModelRegistry.this.loadModels(provider);
            }
        }

        private void unloadModels(IConfigurationElement element) {
            IModelingAssistantModelProvider provider = this.configured.remove(element);
            if (provider != null) {
                ModelingAssistantModelRegistry.this.unloadModels(provider);
            }
        }
    }
}

