/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor.palette;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.IConfiguredHintedElementType;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    private static String PLUGIN_PROTOCOL = "platform:/plugin/";

    protected String _activatorFQN(Palette palette) {
        return palette.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
    }

    protected String _activatorFQN(AbstractToolEntry entry) {
        return this.activatorFQN((EObject)entry.getGroup().getPalette());
    }

    protected String _activatorFQN(ToolGroup group) {
        return this.activatorFQN((EObject)group.getPalette());
    }

    @Localization
    public String i18nKey(EntryBase group) {
        boolean _startsWith_1;
        String rv = group.getCreateMethodName();
        String _switchResult = null;
        boolean _matched = false;
        boolean _startsWith = rv.startsWith("get");
        if (_startsWith) {
            _matched = true;
            _switchResult = this._common_qvto.substringAfter(rv, "get");
        }
        if (!_matched && (_startsWith_1 = rv.startsWith("create"))) {
            _matched = true;
            _switchResult = this._common_qvto.substringAfter(rv, "create");
        }
        if (!_matched) {
            _switchResult = rv;
        }
        return _switchResult;
    }

    @Localization
    public String i18nTitleKey(EntryBase group) {
        String _i18nKey = this.i18nKey(group);
        return _i18nKey + "_title";
    }

    @Localization
    public String i18nDescKey(EntryBase group) {
        String _i18nKey = this.i18nKey(group);
        return _i18nKey + "_desc";
    }

    public Iterable<ToolGroup> collectGroups(Palette palette) {
        LinkedHashSet result = CollectionLiterals.newLinkedHashSet();
        if (palette != null) {
            result.addAll(palette.getGroups());
            EList _groups = palette.getGroups();
            for (ToolGroup group : _groups) {
                Iterables.addAll((Collection)result, this.collectSubGroups(group));
            }
        }
        return result;
    }

    public Iterable<ToolGroup> collectSubGroups(ToolGroup group) {
        return this.collectSubGroups(group, CollectionLiterals.newLinkedList());
    }

    public Iterable<ToolGroup> collectSubGroups(ToolGroup group, Collection<ToolGroup> acc) {
        boolean _not;
        Iterable directSubGroups = Iterables.filter((Iterable)group.getEntries(), ToolGroup.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)directSubGroups);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Iterables.addAll(acc, (Iterable)directSubGroups);
            for (ToolGroup next : directSubGroups) {
                this.collectSubGroups(next, acc);
            }
        }
        return acc;
    }

    public Iterable<AbstractToolEntry> collectTools(Palette palette) {
        Functions.Function1 _function = g -> Iterables.filter((Iterable)g.getEntries(), AbstractToolEntry.class);
        Functions.Function1 _function_1 = tool -> this.isValidTool((AbstractToolEntry)tool);
        return IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.collectGroups(palette), (Functions.Function1)_function)), (Functions.Function1)_function_1);
    }

    public boolean needsNodeToolEntryClass(Palette palette) {
        Functions.Function1 _function = e -> this._common_qvto.notEmpty(e.getGenNodes());
        return IterableExtensions.exists((Iterable)Iterables.filter(this.collectTools(palette), ToolEntry.class), (Functions.Function1)_function);
    }

    public boolean needsLinkToolEntryClass(Palette palette) {
        Functions.Function1 _function = e -> this._common_qvto.notEmpty(e.getGenLinks());
        return IterableExtensions.exists((Iterable)Iterables.filter(this.collectTools(palette), ToolEntry.class), (Functions.Function1)_function);
    }

    public boolean isValidTool(AbstractToolEntry entry) {
        if (entry instanceof ToolEntry) {
            if (((ToolEntry)entry).getQualifiedToolName() != null && !((ToolEntry)entry).getQualifiedToolName().isEmpty()) {
                return true;
            }
            int links = ((ToolEntry)entry).getGenLinks().size();
            int nodes = ((ToolEntry)entry).getGenNodes().size();
            return nodes + links != 0;
        }
        return true;
    }

    public String getToolPath(String it) {
        String result = null;
        boolean _isQuoted = this.isQuoted(it, "\"");
        if (_isQuoted) {
            int _length = it.length();
            int _minus = _length - 1;
            result = it.substring(1, _minus);
        } else {
            result = it;
        }
        return "/" + result;
    }

    public boolean isQuoted(String source, String quoteStr) {
        if (quoteStr == null) {
            return false;
        }
        return source.length() >= quoteStr.length() * 2 && source.startsWith(quoteStr) && source.endsWith(quoteStr);
    }

    public String getConstantIDName(String it) {
        boolean _isQuoted = this.isQuoted(it, "\"");
        if (_isQuoted) {
            int _length = it.length();
            int _minus = _length - 1;
            return this.getUpperAndUnderscoreString(it.substring(1, _minus));
        }
        return this.getUpperAndUnderscoreString(it);
    }

    public String getUpperAndUnderscoreString(String value) {
        return value.toUpperCase().replace(".", "_");
    }

    public String retrieveBundleId(String initialValue, String defaultValue) {
        String result = null;
        boolean _startsWith = initialValue.startsWith(PLUGIN_PROTOCOL);
        if (_startsWith) {
            String tmp = initialValue.substring(PLUGIN_PROTOCOL.length());
            int bundleIdEndIndex = tmp.indexOf("/");
            result = tmp.substring(0, bundleIdEndIndex);
        } else {
            result = defaultValue;
        }
        return result;
    }

    public String retrieveLocalPath(String initialValue) {
        String result = "";
        boolean _startsWith = initialValue.startsWith(PLUGIN_PROTOCOL);
        if (_startsWith) {
            String tmp = initialValue.substring(PLUGIN_PROTOCOL.length());
            int bundleIdEndIndex = tmp.indexOf("/");
            result = tmp.substring(bundleIdEndIndex);
        } else {
            result = initialValue;
        }
        return result;
    }

    public String getRelativePath(EObject it) {
        String path = null;
        URI resourceURI = it.eResource().getURI();
        boolean _isPlatformResource = resourceURI.isPlatformResource();
        if (_isPlatformResource) {
            String platformString = resourceURI.toPlatformString(true);
            Path workspacePath = new Path(platformString);
            workspacePath = workspacePath.removeFirstSegments(1);
            workspacePath = workspacePath.removeLastSegments(1);
            path = workspacePath.toString();
        } else {
            path = "model";
        }
        return path;
    }

    public String getElementTypeConfHRef(String uniqueIdentifier, XMLResource resource) {
        ElementTypeSetConfigurationRegistry.getInstance().getClass();
        String href = null;
        IElementType type = ElementTypeRegistry.getInstance().getType(uniqueIdentifier);
        if (type instanceof IConfiguredHintedElementType) {
            XMLHelperImpl xmlHelper = new XMLHelperImpl(resource);
            HashMap<String, URIHandlerImpl.PlatformSchemeAware> options2 = new HashMap<String, URIHandlerImpl.PlatformSchemeAware>();
            URIHandlerImpl.PlatformSchemeAware _platformSchemeAware = new URIHandlerImpl.PlatformSchemeAware();
            options2.put("URI_HANDLER", _platformSchemeAware);
            xmlHelper.setOptions(options2);
            ElementTypeConfiguration _configuration = ((IConfiguredHintedElementType)type).getConfiguration();
            href = xmlHelper.getHREF((EObject)_configuration);
        }
        return href;
    }

    public String getConfigurationXsiType(String uniqueIdentifier, XMLResource resource) {
        String type = null;
        IElementType eltype = ElementTypeRegistry.getInstance().getType(uniqueIdentifier);
        if (eltype instanceof IConfiguredHintedElementType) {
            ElementTypeConfiguration configuration = ((IConfiguredHintedElementType)eltype).getConfiguration();
            if (configuration instanceof SpecializationTypeConfiguration) {
                type = "elementtypesconfigurations:SpecializationTypeConfiguration";
            } else if (configuration instanceof MetamodelTypeConfiguration) {
                type = "elementtypesconfigurations:MetamodelTypeConfiguration";
            } else if (configuration instanceof ExternallyRegisteredType) {
                type = "elementtypesconfigurations:ExternallyRegisteredType";
            }
        }
        return type;
    }

    public String activatorFQN(EObject entry) {
        if (entry instanceof AbstractToolEntry) {
            return this._activatorFQN((AbstractToolEntry)entry);
        }
        if (entry instanceof ToolGroup) {
            return this._activatorFQN((ToolGroup)entry);
        }
        if (entry instanceof Palette) {
            return this._activatorFQN((Palette)entry);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entry).toString());
    }
}

