/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.transformer;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.transformer.ITransformer;
import org.eclipse.cbi.p2repo.aggregator.transformer.TransformerContextContributor;
import org.eclipse.cbi.p2repo.aggregator.util.AggregatorResourceImpl;
import org.eclipse.cbi.p2repo.aggregator.util.ResourceUtils;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class TransformationManager {
    private static final String LEGACY_TRANSFORMATION_ATTR_SOURCE_ECORE = "sourceEcoreUri";
    private static final String LEGACY_TRANSFORMATION_ATTR_TARGET_NS = "targetNS";
    private static final String LEGACY_TRANSFORMATION_ATTR_TARGET_ECORE = "targetEcoreUri";
    private static final String LEGACY_TRANSFORMATION_ATTR_CLASS = "class";
    private static final String LEGACY_TRANSFORMATION_ATTR_SOURCE_NS = "sourceNS";
    private static final String LEGACY_TRANSFORMATION_ID = "org.eclipse.cbi.p2repo.aggregator.legacy_transformation";
    private static final String LEGACY_TRANSFORMATION_ATTR_SOURCE_TOP_ELEMENT = "sourceTopElement";
    private static final String LEGACY_TRANSFORMATION_ATTR_SOURCE_NS_ATTRIBUTE = "sourceNSAttribute";
    private static final String LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR = "contextContributor";
    private boolean srcNamespaceFound;
    private List<IConfigurationElement> transformationSequence;
    private List<TransformerContextContributor> contextContributors = new ArrayList<TransformerContextContributor>();
    private URI srcResourceURI;

    public static List<IConfigurationElement> resolveTransformationSequence(IConfigurationElement[] transformations, String requiredSourceNS, String requiredTargetNS, List<IConfigurationElement> transformerSequence) {
        IConfigurationElement[] iConfigurationElementArray = transformations;
        int n = transformations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement transformation = iConfigurationElementArray[n2];
            String srcNS = transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_NS);
            String trgtNS = transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_NS);
            if (requiredSourceNS.equals(srcNS)) {
                ArrayList<IConfigurationElement> newTransformerSequence = new ArrayList<IConfigurationElement>();
                newTransformerSequence.addAll(transformerSequence);
                newTransformerSequence.add(transformation);
                if (requiredTargetNS.equals(trgtNS)) {
                    return newTransformerSequence;
                }
                List<IConfigurationElement> result = TransformationManager.resolveTransformationSequence(transformations, trgtNS, requiredTargetNS, newTransformerSequence);
                if (result != null) {
                    return result;
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unable to resolve transformation sequence from " + requiredSourceNS + " to " + requiredTargetNS);
    }

    public TransformationManager(URI srcResourceURI) {
        this(srcResourceURI, null);
    }

    public TransformationManager(URI srcResourceURI, ContributorListener contributorListener) {
        this.srcResourceURI = srcResourceURI;
        HashSet<CallSite> nsPaths = new HashSet<CallSite>();
        IConfigurationElement[] transformations = Platform.getExtensionRegistry().getConfigurationElementsFor(LEGACY_TRANSFORMATION_ID);
        String xmlns = null;
        String topElement = null;
        String nsAttribute = null;
        int i = 0;
        while (xmlns == null && i < transformations.length) {
            topElement = transformations[i].getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_TOP_ELEMENT);
            nsAttribute = transformations[i].getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_NS_ATTRIBUTE);
            ++i;
            if (StringUtils.trimmedOrNull((String)topElement) == null || StringUtils.trimmedOrNull((String)nsAttribute) == null || nsPaths.contains(topElement + "/" + nsAttribute)) continue;
            xmlns = ResourceUtils.getResourceXMLNS(srcResourceURI, topElement, nsAttribute);
            nsPaths.add((CallSite)((Object)(topElement + "/" + nsAttribute)));
        }
        boolean bl = this.srcNamespaceFound = xmlns != null;
        if (this.srcNamespaceFound) {
            String requiredSourceNS = xmlns;
            String requiredTargetNS = "http://www.eclipse.org/cbi/p2repo/2011/aggregator/1.1.0";
            this.transformationSequence = TransformationManager.resolveTransformationSequence(transformations, requiredSourceNS, requiredTargetNS, new ArrayList<IConfigurationElement>());
            for (IConfigurationElement transformation : this.transformationSequence) {
                TransformerContextContributor contextContributor = null;
                try {
                    if (transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR) != null) {
                        contextContributor = (TransformerContextContributor)transformation.createExecutableExtension(LEGACY_TRANSFORMATION_ATTR_CONTEXT_CONTRIBUTOR);
                        if (contributorListener != null) {
                            contributorListener.contributorFound(transformation, contextContributor);
                        }
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException("Deprecated resource was not transformed - transformation wizard cannot be started", e);
                }
                if (contextContributor == null) continue;
                this.contextContributors.add(contextContributor);
            }
        }
    }

    public final List<TransformerContextContributor> getContextContributors() {
        return this.contextContributors;
    }

    public final List<IConfigurationElement> getTransformationSequence() {
        return this.transformationSequence;
    }

    public final boolean isSrcNamespaceFound() {
        return this.srcNamespaceFound;
    }

    public Resource transformResource(boolean resolveProxies) throws IOException, CoreException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (TransformerContextContributor contextContributor : this.contextContributors) {
            contextContributor.contributeToContext(context);
        }
        ResourceSetImpl ecoreRs01 = null;
        Resource ecoreRes01 = null;
        EPackage package01 = null;
        ResourceSetImpl rs01 = null;
        AggregatorResourceImpl res01 = null;
        ResourceSetImpl ecoreRs02 = null;
        Resource ecoreRes02 = null;
        EPackage package02 = null;
        ResourceSetImpl rs02 = null;
        AggregatorResourceImpl res02 = null;
        int idx = 0;
        for (IConfigurationElement transformation : this.transformationSequence) {
            if (idx == 0) {
                ecoreRs01 = new ResourceSetImpl();
                ecoreRs01.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                ecoreRes01 = ecoreRs01.getResource(URI.createURI((String)transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_SOURCE_ECORE)), true);
                package01 = (EPackage)ecoreRes01.getContents().get(0);
                rs01 = new ResourceSetImpl();
                rs01.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                rs01.getPackageRegistry().put((Object)package01.getNsURI(), (Object)package01);
                res01 = rs01.getResource(this.srcResourceURI, true);
                rs01.getResources().add((Object)res01);
                for (Resource.Diagnostic diag : res01.getErrors()) {
                    System.out.println("ERROR: " + diag.getMessage());
                }
                for (Resource.Diagnostic diag : res01.getWarnings()) {
                    System.out.println("WARNING: " + diag.getMessage());
                }
            } else {
                ecoreRs01 = ecoreRs02;
                ecoreRes01 = ecoreRes02;
                package01 = package02;
                rs01 = rs02;
                res01 = res02;
            }
            ++idx;
            File tempFile = File.createTempFile("temp", ".aggr");
            tempFile.deleteOnExit();
            rs02 = new ResourceSetImpl();
            rs02.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            if ("http://www.eclipse.org/cbi/p2repo/2011/aggregator/1.1.0".equals(transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_NS))) {
                package02 = AggregatorPackage.eINSTANCE;
                res02 = new AggregatorResourceImpl(URI.createURI((String)tempFile.toURI().toString()));
                rs02.getResources().add((Object)res02);
            } else {
                ecoreRs02 = new ResourceSetImpl();
                ecoreRs02.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
                ecoreRes02 = ecoreRs02.getResource(URI.createURI((String)transformation.getAttribute(LEGACY_TRANSFORMATION_ATTR_TARGET_ECORE)), true);
                package02 = (EPackage)ecoreRes02.getContents().get(0);
                res02 = rs02.createResource(URI.createURI((String)tempFile.toURI().toString()));
            }
            rs02.getPackageRegistry().put((Object)package02.getNsURI(), (Object)package02);
            ITransformer transformer = (ITransformer)transformation.createExecutableExtension(LEGACY_TRANSFORMATION_ATTR_CLASS);
            transformer.initTransformer((Resource)res01, (Resource)res02, package02, context);
            transformer.startTransformation(resolveProxies);
            if (transformer.getResourceErrors().size() <= 0) continue;
            StringBuilder msg = new StringBuilder();
            for (Resource.Diagnostic diag : transformer.getResourceErrors()) {
                msg.append(diag.getMessage());
                msg.append('\n');
            }
            throw ExceptionUtils.fromMessage((String)msg.toString(), (Object[])new Object[0]);
        }
        return res02;
    }

    public static interface ContributorListener {
        public void contributorFound(IConfigurationElement var1, TransformerContextContributor var2) throws CoreException;
    }
}

