/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.service.IStereotypeRepairService;
import org.eclipse.swt.widgets.Display;

public class StereotypeRepairService
implements IStereotypeRepairService,
IService {
    private static final Lock lock = new ReentrantLock();
    private static final Condition executorsReady = lock.newCondition();
    private static final Queue<PostRepairExecutor> ready = Lists.newLinkedList();
    private static final Map<ModelSet, Set<Resource>> modelSetsInRepair = Maps.newIdentityHashMap();
    private static final Map<ModelSet, PostRepairExecutor> pending = Maps.newIdentityHashMap();
    private static ExecutorService pendingExecutor;
    private ServicesRegistry registry;
    private ModelSet modelSet;
    private ExecutorService executor;

    @Override
    public boolean isRepairing() {
        return StereotypeRepairService.isInRepair(this.modelSet);
    }

    @Override
    public ExecutorService getPostRepairExecutor() {
        return this.executor;
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.modelSet = (ModelSet)this.registry.getService(ModelSet.class);
        this.executor = new PostRepairExecutor((ExecutorService)UIUtil.createUIExecutor((Display)Display.getDefault()));
    }

    public void disposeService() throws ServiceException {
        this.modelSet = null;
        this.registry = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    static boolean isInRepair(ModelSet modelSet) {
        lock.lock();
        try {
            boolean bl = modelSetsInRepair.containsKey(modelSet);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    static void startedRepairing(ModelSet modelSet, Resource resource) {
        lock.lock();
        try {
            Set resources = modelSetsInRepair.get(modelSet);
            if (resources == null) {
                resources = Sets.newIdentityHashSet();
                modelSetsInRepair.put(modelSet, resources);
            }
            resources.add(resource);
        }
        finally {
            lock.unlock();
        }
    }

    static void finishedRepairing(ModelSet modelSet, Resource resource) {
        lock.lock();
        try {
            Set<Resource> resources = modelSetsInRepair.get(modelSet);
            if (resources != null) {
                resources.remove(resource);
                if (resources.isEmpty()) {
                    modelSetsInRepair.remove(modelSet);
                    Activator.log.trace("executor", "Model Repair completed");
                    PostRepairExecutor executor = pending.remove(modelSet);
                    if (executor != null) {
                        ready.offer(executor);
                        executorsReady.signalAll();
                        Activator.log.trace("executor", "Pending post-repair executor ready");
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void pending(PostRepairExecutor executor) {
        lock.lock();
        try {
            pending.put(executor.getModelSet(), executor);
            Activator.log.trace("executor", "Post-repair executor pending");
            if (pendingExecutor == null || pendingExecutor.isShutdown()) {
                pendingExecutor = Executors.newSingleThreadExecutor();
                StereotypeRepairService.start(pendingExecutor);
                Activator.log.trace("executor", "Post-repair scheduling executor started");
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void start(final ExecutorService executor) {
        lock.lock();
        try {
            executor.execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    protected class PostRepairExecutor
    extends AbstractExecutorService {
        private final ExecutorService delegate;
        private volatile boolean shutdown;
        private final Lock lock = new ReentrantLock();
        private List<Runnable> pending = Lists.newLinkedList();

        protected PostRepairExecutor(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(Runnable command) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Executor is shut down");
            }
            if (!StereotypeRepairService.isInRepair(StereotypeRepairService.this.modelSet)) {
                try {
                    this.delegate.execute(command);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            } else {
                this.lock.lock();
                try {
                    this.pending.add(command);
                    StereotypeRepairService.pending(this);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public void shutdown() {
            this.shutdown = true;
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown = true;
            ArrayList result = Lists.newArrayList();
            this.lock.lock();
            try {
                result.addAll(this.pending);
                this.pending.clear();
            }
            finally {
                this.lock.unlock();
            }
            result.addAll(this.delegate.shutdownNow());
            return result;
        }

        @Override
        public boolean isShutdown() {
            return this.shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.shutdown && this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        ModelSet getModelSet() {
            return StereotypeRepairService.this.modelSet;
        }

        boolean processPending() {
            boolean result;
            boolean bl = result = !StereotypeRepairService.isInRepair(StereotypeRepairService.this.modelSet);
            if (result) {
                this.lock.lock();
                try {
                    try {
                        for (Runnable next : this.pending) {
                            this.delegate.execute(next);
                        }
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                    this.pending.clear();
                }
                finally {
                    this.lock.unlock();
                }
            }
            return result;
        }
    }
}

