/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.HyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.ui.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.swt.widgets.Shell;

public class HyperLinkPopupBarEditPolicy
extends PapyrusPopupBarEditPolicy {
    private IPageIconsRegistry editorRegistry;
    private HyperLinkManagerShell hyperLinkManagerShell;
    protected ArrayList<HyperLinkObject> hyperLinkObjectList;
    protected HyperLinkHelperFactory hyperlinkHelperFactory;

    public HyperLinkPopupBarEditPolicy() {
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        this.hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
    }

    protected void appendPopupBarDescriptors() {
        try {
            this.hyperLinkObjectList = this.hyperlinkHelperFactory.getAllreferenced((EModelElement)((IGraphicalEditPart)this.getHost()).getNotationView());
            this.addHyperlinks();
        }
        catch (HyperLinkException e) {
            Activator.log.error((Throwable)e);
        }
        this.addPopupBarDescriptor(Activator.getDefault().getIcon("hyperlink"), new AddHyperlinkTool(), "Add hyperlink");
    }

    private void addHyperlinks() {
        ILabelProvider labelProvider = null;
        boolean localLabelProvider = false;
        try {
            EObject contextElement = EMFHelper.getEObject((Object)this.getHost());
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)contextElement)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            localLabelProvider = true;
        }
        for (HyperLinkObject hyperlink : this.hyperLinkObjectList) {
            String tooltip = labelProvider instanceof CellLabelProvider ? ((CellLabelProvider)labelProvider).getToolTipText((Object)hyperlink) : labelProvider.getText((Object)hyperlink);
            this.addPopupBarDescriptor(labelProvider.getImage((Object)hyperlink), new NavigateHyperlinkTool(hyperlink), tooltip);
        }
        if (localLabelProvider) {
            labelProvider.dispose();
        }
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistry getEditorRegistry() {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry();
        }
        return this.editorRegistry;
    }

    protected abstract class AbstractHyperlinkTool
    extends AbstractTool
    implements DragTracker {
        protected AbstractHyperlinkTool() {
        }

        protected boolean handleButtonDown(int button) {
            this.setCurrentCommand(this.getCommand());
            return true;
        }

        protected boolean handleButtonUp(int button) {
            this.perform();
            return true;
        }

        private void perform() {
            org.eclipse.gef.commands.Command command = this.getCurrentCommand();
            if (command != null && command.canExecute()) {
                command.execute();
            }
        }
    }

    protected class AddHyperlinkTool
    extends AbstractHyperlinkTool {
        protected AddHyperlinkTool() {
        }

        protected String getCommandName() {
            return "add hyperlink";
        }

        protected org.eclipse.gef.commands.Command getCommand() {
            return new org.eclipse.gef.commands.Command("Add Hyperlink"){

                public void execute() {
                    Shell parentShell = EditorHelper.getActiveShell();
                    ((AddHyperlinkTool)AddHyperlinkTool.this).HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell = new HyperLinkManagerShell(parentShell, HyperLinkPopupBarEditPolicy.this.getEditorRegistry(), ((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getEditingDomain(), (EModelElement)((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView().getElement(), (EModelElement)((IGraphicalEditPart)HyperLinkPopupBarEditPolicy.this.getHost()).getNotationView(), ((AddHyperlinkTool)AddHyperlinkTool.this).HyperLinkPopupBarEditPolicy.this.hyperlinkHelperFactory);
                    ((AddHyperlinkTool)AddHyperlinkTool.this).HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.setInput(((AddHyperlinkTool)AddHyperlinkTool.this).HyperLinkPopupBarEditPolicy.this.hyperLinkObjectList);
                    HyperLinkPopupBarEditPolicy.this.hideDiagramAssistant();
                    ((AddHyperlinkTool)AddHyperlinkTool.this).HyperLinkPopupBarEditPolicy.this.hyperLinkManagerShell.open();
                }
            };
        }
    }

    protected class NavigateHyperlinkTool
    extends AbstractHyperlinkTool {
        private final HyperLinkObject hyperlink;

        public NavigateHyperlinkTool(HyperLinkObject hyperlink) {
            this.hyperlink = hyperlink;
        }

        protected String getCommandName() {
            return "open hyperlink";
        }

        protected org.eclipse.gef.commands.Command getCommand() {
            return new org.eclipse.gef.commands.Command("Open Hyperlink"){

                public void execute() {
                    if (NavigateHyperlinkTool.this.hyperlink.needsOpenCommand()) {
                        try {
                            TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)HyperLinkPopupBarEditPolicy.this.getHost());
                            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, this.getLabel()){

                                protected void doExecute() {
                                    (this).NavigateHyperlinkTool.this.hyperlink.openLink();
                                }
                            });
                        }
                        catch (ServiceException serviceException) {}
                    } else {
                        NavigateHyperlinkTool.this.hyperlink.openLink();
                    }
                }
            };
        }
    }
}

