/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.emf.resource.ICrossReferenceIndex;

public abstract class AbstractCrossReferenceIndex
implements ICrossReferenceIndex {
    public static final String SHARD_ANNOTATION_SOURCE = "http://www.eclipse.org/papyrus/2016/resource/shard";
    static final int MAX_INDEX_JOBS = 5;
    final Object sync = new Object();
    final SetMultimap<URI, URI> outgoingReferences = HashMultimap.create();
    final SetMultimap<URI, URI> incomingReferences = HashMultimap.create();
    final SetMultimap<URI, URI> resourceToSubunits = HashMultimap.create();
    final SetMultimap<URI, URI> subunitToParents = HashMultimap.create();
    SetMultimap<URI, URI> aggregateOutgoingReferences;
    SetMultimap<URI, URI> aggregateIncomingReferences;
    SetMultimap<URI, URI> aggregateResourceToSubunits;
    SetMultimap<URI, URI> aggregateSubunitToParents;
    final SetMultimap<URI, String> shards = HashMultimap.create();

    AbstractCrossReferenceIndex() {
    }

    @Override
    public ListenableFuture<SetMultimap<URI, URI>> getOutgoingCrossReferencesAsync() {
        return this.afterIndex(this.getOutgoingCrossReferencesCallable());
    }

    @Override
    public SetMultimap<URI, URI> getOutgoingCrossReferences() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getOutgoingCrossReferencesCallable()));
    }

    Callable<SetMultimap<URI, URI>> getOutgoingCrossReferencesCallable() {
        return this.sync(() -> ImmutableSetMultimap.copyOf(this.outgoingReferences));
    }

    @Override
    public ListenableFuture<Set<URI>> getOutgoingCrossReferencesAsync(URI resourceURI) {
        return this.afterIndex(this.getOutgoingCrossReferencesCallable(resourceURI));
    }

    @Override
    public Set<URI> getOutgoingCrossReferences(URI resourceURI) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getOutgoingCrossReferencesCallable(resourceURI)));
    }

    Callable<Set<URI>> getOutgoingCrossReferencesCallable(URI resourceURI) {
        return this.sync(() -> {
            String ext = resourceURI.fileExtension();
            URI withoutExt = resourceURI.trimFileExtension();
            Set result = this.getAggregateOutgoingCrossReferences().get((Object)withoutExt).stream().map(uri -> uri.appendFileExtension(ext)).collect(Collectors.toSet());
            return Collections.unmodifiableSet(result);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SetMultimap<URI, URI> getAggregateOutgoingCrossReferences() {
        SetMultimap<URI, URI> result;
        Object object = this.sync;
        synchronized (object) {
            if (this.aggregateOutgoingReferences == null) {
                this.aggregateOutgoingReferences = HashMultimap.create();
                for (Map.Entry next : this.outgoingReferences.entries()) {
                    this.aggregateOutgoingReferences.put((Object)((URI)next.getKey()).trimFileExtension(), (Object)((URI)next.getValue()).trimFileExtension());
                }
            }
            result = this.aggregateOutgoingReferences;
        }
        return result;
    }

    @Override
    public ListenableFuture<SetMultimap<URI, URI>> getIncomingCrossReferencesAsync() {
        return this.afterIndex(this.getIncomingCrossReferencesCallable());
    }

    @Override
    public SetMultimap<URI, URI> getIncomingCrossReferences() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getIncomingCrossReferencesCallable()));
    }

    Callable<SetMultimap<URI, URI>> getIncomingCrossReferencesCallable() {
        return this.sync(() -> ImmutableSetMultimap.copyOf(this.incomingReferences));
    }

    @Override
    public ListenableFuture<Set<URI>> getIncomingCrossReferencesAsync(URI resourceURI) {
        return this.afterIndex(this.getIncomingCrossReferencesCallable(resourceURI));
    }

    @Override
    public Set<URI> getIncomingCrossReferences(URI resourceURI) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getIncomingCrossReferencesCallable(resourceURI)));
    }

    Callable<Set<URI>> getIncomingCrossReferencesCallable(URI resourceURI) {
        return this.sync(() -> {
            String ext = resourceURI.fileExtension();
            URI withoutExt = resourceURI.trimFileExtension();
            Set result = this.getAggregateIncomingCrossReferences().get((Object)withoutExt).stream().map(uri -> uri.appendFileExtension(ext)).collect(Collectors.toSet());
            return Collections.unmodifiableSet(result);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SetMultimap<URI, URI> getAggregateIncomingCrossReferences() {
        SetMultimap<URI, URI> result;
        Object object = this.sync;
        synchronized (object) {
            if (this.aggregateIncomingReferences == null) {
                this.aggregateIncomingReferences = HashMultimap.create();
                for (Map.Entry next : this.incomingReferences.entries()) {
                    this.aggregateIncomingReferences.put((Object)((URI)next.getKey()).trimFileExtension(), (Object)((URI)next.getValue()).trimFileExtension());
                }
            }
            result = this.aggregateIncomingReferences;
        }
        return result;
    }

    @Override
    public ListenableFuture<Boolean> isShardAsync(URI resourceURI) {
        return this.afterIndex(this.getIsShardCallable(resourceURI));
    }

    @Override
    public boolean isShard(URI resourceURI) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getIsShardCallable(resourceURI)));
    }

    final <V> V sync(Future<V> future) throws CoreException {
        try {
            return future.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", "Failed to access the resource shard index", (Throwable)e));
        }
        catch (TimeoutException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", "Timeout during access the resource shard index", (Throwable)e));
        }
    }

    Callable<Boolean> getIsShardCallable(URI shardURI) {
        return this.sync(() -> this.isShard0(shardURI.trimFileExtension()));
    }

    boolean isShard0(URI uriWithoutExtension) {
        return !this.shards.get((Object)uriWithoutExtension).isEmpty();
    }

    void setShard(URI resourceURI, boolean isShard) {
        if (isShard) {
            this.shards.put((Object)resourceURI.trimFileExtension(), (Object)resourceURI.fileExtension());
        } else {
            this.shards.remove((Object)resourceURI.trimFileExtension(), (Object)resourceURI.fileExtension());
        }
    }

    @Override
    public ListenableFuture<SetMultimap<URI, URI>> getSubunitsAsync() {
        return this.afterIndex(this.getSubunitsCallable());
    }

    @Override
    public SetMultimap<URI, URI> getSubunits() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getSubunitsCallable()));
    }

    Callable<SetMultimap<URI, URI>> getSubunitsCallable() {
        return this.sync(() -> ImmutableSetMultimap.copyOf(this.resourceToSubunits));
    }

    @Override
    public ListenableFuture<Set<URI>> getSubunitsAsync(URI resourceURI) {
        return this.getSubunitsAsync(resourceURI, true);
    }

    @Override
    public Set<URI> getSubunits(URI resourceURI) throws CoreException {
        return this.getSubunits(resourceURI, true);
    }

    @Override
    public ListenableFuture<Set<URI>> getSubunitsAsync(URI resourceURI, boolean shardOnly) {
        return this.afterIndex(this.getSubunitsCallable(resourceURI, shardOnly));
    }

    @Override
    public Set<URI> getSubunits(URI resourceURI, boolean shardOnly) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getSubunitsCallable(resourceURI, shardOnly)));
    }

    Callable<Set<URI>> getSubunitsCallable(URI shardURI, boolean shardOnly) {
        return this.sync(() -> {
            String ext = shardURI.fileExtension();
            URI withoutExt = shardURI.trimFileExtension();
            Stream<Object> intermediateResult = this.getAggregateShards().get((Object)withoutExt).stream();
            if (shardOnly) {
                intermediateResult = intermediateResult.filter(this::isShard0);
            }
            Set result = intermediateResult.map(uri -> uri.appendFileExtension(ext)).collect(Collectors.toSet());
            return Collections.unmodifiableSet(result);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SetMultimap<URI, URI> getAggregateShards() {
        SetMultimap<URI, URI> result;
        Object object = this.sync;
        synchronized (object) {
            if (this.aggregateResourceToSubunits == null) {
                this.aggregateResourceToSubunits = HashMultimap.create();
                for (Map.Entry next : this.resourceToSubunits.entries()) {
                    this.aggregateResourceToSubunits.put((Object)((URI)next.getKey()).trimFileExtension(), (Object)((URI)next.getValue()).trimFileExtension());
                }
            }
            result = this.aggregateResourceToSubunits;
        }
        return result;
    }

    @Override
    public ListenableFuture<Set<URI>> getParentsAsync(URI shardURI) {
        return this.getParentsAsync(shardURI, true);
    }

    @Override
    public ListenableFuture<Set<URI>> getParentsAsync(URI resourceURI, boolean shardOnly) {
        return this.afterIndex(this.getParentsCallable(resourceURI, shardOnly));
    }

    @Override
    public Set<URI> getParents(URI shardURI) throws CoreException {
        return this.getParents(shardURI, true);
    }

    @Override
    public Set<URI> getParents(URI resourceURI, boolean shardOnly) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getParentsCallable(resourceURI, shardOnly)));
    }

    @Override
    public Set<URI> getParents(URI subunitURI, ICrossReferenceIndex alternate) throws CoreException {
        return this.getParents(subunitURI, true, alternate);
    }

    @Override
    public Set<URI> getParents(URI subunitURI, boolean shardOnly, ICrossReferenceIndex alternate) throws CoreException {
        if (alternate == this) {
            throw new IllegalArgumentException("self alternate");
        }
        Callable<Set> elseCallable = alternate == null ? null : () -> alternate.getParents(subunitURI, shardOnly);
        return this.ifAvailable(this.getParentsCallable(subunitURI, shardOnly), elseCallable);
    }

    Callable<Set<URI>> getParentsCallable(URI shardURI, boolean shardOnly) {
        return this.sync(() -> {
            Set result;
            URI withoutExt = shardURI.trimFileExtension();
            if (shardOnly && !this.isShard0(withoutExt)) {
                result = Collections.emptySet();
            } else {
                String ext = shardURI.fileExtension();
                result = this.getAggregateShardToParents().get((Object)withoutExt).stream().map(uri -> uri.appendFileExtension(ext)).collect(Collectors.toSet());
                result = Collections.unmodifiableSet(result);
            }
            return result;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SetMultimap<URI, URI> getAggregateShardToParents() {
        SetMultimap<URI, URI> result;
        Object object = this.sync;
        synchronized (object) {
            if (this.aggregateSubunitToParents == null) {
                this.aggregateSubunitToParents = HashMultimap.create();
                for (Map.Entry next : this.subunitToParents.entries()) {
                    this.aggregateSubunitToParents.put((Object)((URI)next.getKey()).trimFileExtension(), (Object)((URI)next.getValue()).trimFileExtension());
                }
            }
            result = this.aggregateSubunitToParents;
        }
        return result;
    }

    @Override
    public ListenableFuture<Set<URI>> getRootsAsync(URI shardURI) {
        return this.getRootsAsync(shardURI, true);
    }

    @Override
    public ListenableFuture<Set<URI>> getRootsAsync(URI shardURI, boolean shardOnly) {
        return this.afterIndex(this.getRootsCallable(shardURI, shardOnly));
    }

    @Override
    public Set<URI> getRoots(URI shardURI) throws CoreException {
        return this.getRoots(shardURI, true);
    }

    @Override
    public Set<URI> getRoots(URI shardURI, boolean shardOnly) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getRootsCallable(shardURI, shardOnly)));
    }

    @Override
    public Set<URI> getRoots(URI subunitURI, ICrossReferenceIndex alternate) throws CoreException {
        return this.getRoots(subunitURI, true, alternate);
    }

    @Override
    public Set<URI> getRoots(URI subunitURI, boolean shardOnly, ICrossReferenceIndex alternate) throws CoreException {
        if (alternate == this) {
            throw new IllegalArgumentException("self alternate");
        }
        Callable<Set> elseCallable = alternate == null ? null : () -> alternate.getRoots(subunitURI, shardOnly);
        return this.ifAvailable(this.getRootsCallable(subunitURI, shardOnly), elseCallable);
    }

    Callable<Set<URI>> getRootsCallable(URI subunitURI, boolean shardOnly) {
        return this.sync(() -> {
            ImmutableSet result;
            URI withoutExt = subunitURI.trimFileExtension();
            if (shardOnly && !this.isShard0(withoutExt)) {
                result = Collections.emptySet();
            } else {
                ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
                SetMultimap<URI, URI> subunitToParents = this.getAggregateShardToParents();
                LinkedList queue = Lists.newLinkedList();
                HashSet cycleDetect = Sets.newHashSet();
                String ext = subunitURI.fileExtension();
                queue.add(withoutExt);
                URI next = (URI)queue.poll();
                while (next != null) {
                    if (cycleDetect.add(next)) {
                        if ((!shardOnly || this.isShard0(next)) && subunitToParents.containsKey((Object)next)) {
                            queue.addAll(subunitToParents.get((Object)next));
                        } else if (!next.equals(withoutExt)) {
                            resultBuilder.add((Object)next.appendFileExtension(ext));
                        }
                    }
                    next = (URI)queue.poll();
                }
                result = resultBuilder.build();
            }
            return result;
        });
    }

    final <V> Callable<V> sync(final Callable<V> callable) {
        return callable instanceof SyncCallable ? callable : new SyncCallable<V>(this){

            @Override
            protected V doCall() throws Exception {
                return callable.call();
            }
        };
    }

    abstract <V> ListenableFuture<V> afterIndex(Callable<V> var1);

    abstract <V> V ifAvailable(Callable<V> var1, Callable<? extends V> var2) throws CoreException;

    private abstract class SyncCallable<V>
    implements Callable<V> {
        private SyncCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final V call() throws Exception {
            Object object = AbstractCrossReferenceIndex.this.sync;
            synchronized (object) {
                return this.doCall();
            }
        }

        protected abstract V doCall() throws Exception;
    }
}

