/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.IColumnGroupModelListener;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

public class ColumnGroupExpandCollapseLayer
extends AbstractColumnHideShowLayer
implements IColumnGroupModelListener {
    private final ColumnGroupModel[] models;

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        this(underlyingLayer, new ColumnGroupModel[]{model});
    }

    public ColumnGroupExpandCollapseLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel ... models) {
        super(underlyingLayer);
        this.models = models;
        ColumnGroupModel[] columnGroupModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnGroupModel model = columnGroupModelArray[n2];
            model.registerColumnGroupModelListener(this);
            ++n2;
        }
        this.registerCommandHandler(new ColumnGroupExpandCollapseCommandHandler(this));
    }

    public ColumnGroupModel getModel(int row) {
        if (row >= this.models.length) {
            row = this.models.length - 1;
        }
        return this.models[row];
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        boolean isHiddeninUnderlyingLayer = ColumnGroupUtils.isColumnIndexHiddenInUnderLyingLayer(columnIndex, this, underlyingLayer);
        if (isHiddeninUnderlyingLayer) {
            return true;
        }
        ColumnGroupModel[] columnGroupModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isCollapsedAndStaticColumn;
            ColumnGroupModel model = columnGroupModelArray[n2];
            ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
            boolean bl = isCollapsedAndStaticColumn = columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, underlyingLayer, model);
            if (isCollapsedAndStaticColumn) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        HashSet<Integer> hiddenColumnIndexes = new HashSet<Integer>();
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingColumnCount = underlyingLayer.getColumnCount();
        int i = 0;
        while (i < underlyingColumnCount) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(i);
            ColumnGroupModel[] columnGroupModelArray = this.models;
            int n = this.models.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnGroupModel model = columnGroupModelArray[n2];
                ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
                if (columnGroup != null && columnGroup.isCollapsed() && !ColumnGroupUtils.isStaticOrFirstVisibleColumn(columnIndex, underlyingLayer, underlyingLayer, model)) {
                    hiddenColumnIndexes.add(columnIndex);
                }
                ++n2;
            }
            ++i;
        }
        return hiddenColumnIndexes;
    }

    @Override
    public void columnGroupModelChanged() {
        this.invalidateCache();
    }
}

