/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLASResourceImpl
extends ASResourceImpl {
    private Map<Type, EClassifier> uml2ecore = null;

    public UMLASResourceImpl(@NonNull URI uri, @NonNull ASResourceFactory asResourceFactory) {
        super(uri, asResourceFactory);
    }

    public @Nullable EClassifier getEClassifier(@NonNull Type umlType) {
        EClassifier eClassifier;
        if (this.uml2ecore == null) {
            this.uml2ecore = new HashMap<Type, EClassifier>();
        }
        if ((eClassifier = this.uml2ecore.get(umlType)) != null) {
            return eClassifier;
        }
        if (this.uml2ecore.containsKey(umlType)) {
            return null;
        }
        Package umlPackage = umlType.getPackage();
        if (umlPackage != null) {
            String typeName = umlType.getName();
            if ("http://www.omg.org/spec/UML/20131001".equals(umlPackage.getURI())) {
                eClassifier = UMLPackage.eINSTANCE.getEClassifier(typeName);
            } else if ("http://www.omg.org/spec/PrimitiveTypes/20131001".equals(umlPackage.getURI())) {
                eClassifier = TypesPackage.eINSTANCE.getEClassifier(typeName);
            }
        }
        this.uml2ecore.put(umlType, eClassifier);
        return eClassifier;
    }

    public void load(Map<?, ?> options) throws IOException {
        @NonNull URI umlURI = this.uri.trimFileExtension();
        UML2AS.loadFromUML((ASResource)this, umlURI);
        super.load(options);
    }
}

