/*
 * Decompiled with CFR 0.152.
 */
package dataaccess.expressions.literals.util;

import dataaccess.expressions.literals.BinaryLiteral;
import dataaccess.expressions.literals.BooleanLiteral;
import dataaccess.expressions.literals.Literal;
import dataaccess.expressions.literals.LiteralsPackage;
import dataaccess.expressions.literals.NumberLiteral;
import dataaccess.expressions.literals.ObjectLiteral;
import dataaccess.expressions.literals.StringLiteral;
import dataaccess.expressions.literals.TimePointLiteral;
import dataaccess.expressions.literals.ValueInit;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralsValidator
extends EObjectValidator {
    public static final LiteralsValidator INSTANCE = new LiteralsValidator();
    public static final String DIAGNOSTIC_SOURCE = "dataaccess.expressions.literals";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String OBJECT_LITERAL__OBJECT_LITERALS_FOR_VALUE_CLASSES_ONLY__EEXPRESSION = "self.valueClass.valueType";
    protected static final String OBJECT_LITERAL__OBJECT_LITERAL_PROPERTIES_ON_RIGHT_CLASS__EEXPRESSION = "self.propertyValues->forAll(vi|vi.forEnd.otherEnd().type.clazz = self.valueClass)";
    protected static final String OBJECT_LITERAL__VALUES_MUST_BE_PROVIDED_FOR_ALL_MANDATORY_PROPERTIES__EEXPRESSION = "self.valueClass.getEqualityRelevantAssociationEnds()->select(ae | ae.otherEnd().type.lowerMultiplicity > 0)->forAll(ae |\r\n      self.propertyValues->exists(pv | pv.forEnd.otherEnd() = ae))";
    protected static final String VALUE_INIT__VALUE_INIT_TYPE_CONFORMS__EEXPRESSION = "self.value.getType().conformsTo(self.forEnd.type)";

    protected EPackage getEPackage() {
        return LiteralsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateLiteral((Literal)value, diagnostics, context);
            }
            case 1: {
                return this.validateBinaryLiteral((BinaryLiteral)value, diagnostics, context);
            }
            case 2: {
                return this.validateStringLiteral((StringLiteral)value, diagnostics, context);
            }
            case 3: {
                return this.validateNumberLiteral((NumberLiteral)value, diagnostics, context);
            }
            case 4: {
                return this.validateTimePointLiteral((TimePointLiteral)value, diagnostics, context);
            }
            case 5: {
                return this.validateBooleanLiteral((BooleanLiteral)value, diagnostics, context);
            }
            case 6: {
                return this.validateObjectLiteral((ObjectLiteral)value, diagnostics, context);
            }
            case 7: {
                return this.validateValueInit((ValueInit)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateLiteral(Literal literal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(literal, diagnostics, context);
    }

    public boolean validateBinaryLiteral(BinaryLiteral binaryLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(binaryLiteral, diagnostics, context);
    }

    public boolean validateStringLiteral(StringLiteral stringLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stringLiteral, diagnostics, context);
    }

    public boolean validateNumberLiteral(NumberLiteral numberLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(numberLiteral, diagnostics, context);
    }

    public boolean validateTimePointLiteral(TimePointLiteral timePointLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(timePointLiteral, diagnostics, context);
    }

    public boolean validateBooleanLiteral(BooleanLiteral booleanLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(booleanLiteral, diagnostics, context);
    }

    public boolean validateObjectLiteral(ObjectLiteral objectLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(objectLiteral, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(objectLiteral, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectLiteral_ObjectLiteralsForValueClassesOnly(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectLiteral_ObjectLiteralPropertiesOnRightClass(objectLiteral, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateObjectLiteral_ValuesMustBeProvidedForAllMandatoryProperties(objectLiteral, diagnostics, context);
        }
        return result;
    }

    public boolean validateObjectLiteral_ObjectLiteralsForValueClassesOnly(ObjectLiteral objectLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LiteralsPackage.Literals.OBJECT_LITERAL, objectLiteral, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectLiteralsForValueClassesOnly", OBJECT_LITERAL__OBJECT_LITERALS_FOR_VALUE_CLASSES_ONLY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectLiteral_ObjectLiteralPropertiesOnRightClass(ObjectLiteral objectLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LiteralsPackage.Literals.OBJECT_LITERAL, objectLiteral, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ObjectLiteralPropertiesOnRightClass", OBJECT_LITERAL__OBJECT_LITERAL_PROPERTIES_ON_RIGHT_CLASS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateObjectLiteral_ValuesMustBeProvidedForAllMandatoryProperties(ObjectLiteral objectLiteral, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LiteralsPackage.Literals.OBJECT_LITERAL, objectLiteral, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValuesMustBeProvidedForAllMandatoryProperties", OBJECT_LITERAL__VALUES_MUST_BE_PROVIDED_FOR_ALL_MANDATORY_PROPERTIES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateValueInit(ValueInit valueInit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(valueInit, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(valueInit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(valueInit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateValueInit_ValueInitTypeConforms(valueInit, diagnostics, context);
        }
        return result;
    }

    public boolean validateValueInit_ValueInitTypeConforms(ValueInit valueInit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(LiteralsPackage.Literals.VALUE_INIT, valueInit, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValueInitTypeConforms", VALUE_INIT__VALUE_INIT_TYPE_CONFORMS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

