/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractEvaluationOperation;
import org.eclipse.ocl.pivot.library.AbstractOperation;

public abstract class AbstractDispatchOperation
extends AbstractEvaluationOperation {
    private static final @NonNull AbstractOperation BAD_OPERATION = new AbstractOperation(){

        @Override
        public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
            return null;
        }

        @Override
        public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
            return null;
        }
    };
    private final @NonNull Map<@NonNull Class<?>, @NonNull AbstractOperation> class2operation = new HashMap();

    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        Object source = sourceAndArgumentValues[0];
        if (source == null) {
            return null;
        }
        Class<?> jClass = source.getClass();
        AbstractOperation abstractOperation = this.class2operation.get(jClass);
        if (abstractOperation == null) {
            abstractOperation = this.resolve(jClass);
            if (abstractOperation == null) {
                abstractOperation = BAD_OPERATION;
                this.class2operation.put(jClass, abstractOperation);
            }
            assert (this.class2operation.get(jClass) == abstractOperation);
        }
        return abstractOperation.basicEvaluate(executor, caller, sourceAndArgumentValues);
    }

    protected void install(@NonNull Class<?> jClass, @NonNull AbstractOperation operation) {
        this.class2operation.put(jClass, operation);
    }

    private @Nullable AbstractOperation resolve(@NonNull Class<?> jClass) {
        Class<?>[] classArray = jClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> jInterface = classArray[n2];
            assert (jInterface != null);
            AbstractOperation abstractOperation = this.class2operation.get(jInterface);
            if (abstractOperation != null) {
                this.class2operation.put(jClass, abstractOperation);
                return abstractOperation;
            }
            abstractOperation = this.resolve(jInterface);
            if (abstractOperation != null) {
                this.class2operation.put(jClass, abstractOperation);
                return abstractOperation;
            }
            ++n2;
        }
        Class<?> jSuperclass = jClass.getSuperclass();
        if (jSuperclass != null) {
            AbstractOperation abstractOperation = this.class2operation.get(jSuperclass);
            if (abstractOperation != null) {
                this.class2operation.put(jClass, abstractOperation);
                return abstractOperation;
            }
            abstractOperation = this.resolve(jSuperclass);
            if (abstractOperation != null) {
                this.class2operation.put(jClass, abstractOperation);
                return abstractOperation;
            }
        }
        return null;
    }

    public String toString() {
        ArrayList<@NonNull Class<?>> keys = new ArrayList(this.class2operation.keySet());
        Collections.sort(keys, new Comparator<Class<?>>(){

            @Override
            public int compare(@NonNull Class<?> o1, @NonNull Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder s = new StringBuilder();
        for (Class clazz : keys) {
            s.append(clazz + " => " + this.class2operation.get(clazz) + "\n");
        }
        return s.toString();
    }
}

