/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTypeId;
import org.eclipse.ocl.pivot.internal.ids.EnumerationLiteralIdImpl;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfWeakReference;

public class EnumerationIdImpl
extends AbstractTypeId
implements EnumerationId {
    protected final @NonNull PackageId parent;
    protected final @NonNull String name;
    protected final int hashCode;
    private @Nullable WeakHashMapOfWeakReference<String, EnumerationLiteralId> memberEnumerationLiterals = null;

    public EnumerationIdImpl(@NonNull PackageId parent, @NonNull String name) {
        this.hashCode = 97 * parent.hashCode() + name.hashCode();
        this.parent = parent;
        this.name = name;
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitEnumerationId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        if (this.parent instanceof NsURIPackageId) {
            return this.name;
        }
        return this.parent + "::" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull EnumerationLiteralId getEnumerationLiteralId(@NonNull String name) {
        WeakHashMapOfWeakReference<String, EnumerationLiteralId> memberEnumerationLiterals2 = this.memberEnumerationLiterals;
        if (memberEnumerationLiterals2 == null) {
            EnumerationIdImpl enumerationIdImpl = this;
            synchronized (enumerationIdImpl) {
                memberEnumerationLiterals2 = this.memberEnumerationLiterals;
                if (memberEnumerationLiterals2 == null) {
                    this.memberEnumerationLiterals = memberEnumerationLiterals2 = new WeakHashMapOfWeakReference<String, EnumerationLiteralId>(){

                        @Override
                        protected @NonNull EnumerationLiteralId newId(@NonNull String name) {
                            return new EnumerationLiteralIdImpl(EnumerationIdImpl.this, name);
                        }
                    };
                }
            }
        }
        return memberEnumerationLiterals2.getId(name);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "Enumeration";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull PackageId getParent() {
        return this.parent;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.parent + "::" + this.name;
    }
}

