/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.executor;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.internal.executor.AbstractSpecializedType;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public class ExecutorMapType
extends AbstractSpecializedType
implements MapType {
    protected final @NonNull Type keyType;
    protected final @NonNull Type valueType;
    protected final @NonNull MapTypeId typeId;

    public ExecutorMapType(@NonNull String name, @NonNull Class containerType, @NonNull Type keyType, @NonNull Type valueType) {
        super(name, containerType);
        this.keyType = keyType;
        this.valueType = valueType;
        this.typeId = IdManager.getMapTypeId(name).getSpecializedId(keyType.getTypeId(), valueType.getTypeId());
    }

    @Override
    public boolean conformsTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof MapType)) {
            return false;
        }
        return TypeUtil.conformsToMapType(standardLibrary, this, (MapType)type);
    }

    @Override
    public @NonNull Class getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        StandardLibrary standardLibrary = idResolver.getStandardLibrary();
        if (!(type instanceof ExecutorMapType)) {
            return standardLibrary.getOclAnyType();
        }
        ExecutorMapType thatClass = (ExecutorMapType)type;
        Class commonContainerClass = this.containerType;
        Type commonKeyClass = this.keyType.getCommonType(idResolver, thatClass.getKeyType());
        Type commonValueClass = this.valueType.getCommonType(idResolver, thatClass.getValueType());
        if (commonContainerClass == this.containerType && commonKeyClass == this.keyType && commonValueClass == this.valueType) {
            return this;
        }
        if (commonContainerClass == thatClass.containerType && commonKeyClass == this.keyType && commonValueClass == this.valueType) {
            return thatClass;
        }
        return standardLibrary.getMapType(standardLibrary.getMapType(), commonKeyClass, commonValueClass);
    }

    @Override
    public @NonNull MapType getContainerType() {
        return (MapType)this.containerType;
    }

    @Override
    public Class getEntryClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type getKeyType() {
        return this.keyType;
    }

    @Override
    public @NonNull List<Operation> getOwnedOperations() {
        return this.containerType.getOwnedOperations();
    }

    @Override
    public @NonNull MapTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof MapType)) {
            return false;
        }
        return TypeUtil.isEqualToMapType(standardLibrary, this, (MapType)type);
    }

    @Override
    public boolean isKeysAreNullFree() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValuesAreNullFree() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntryClass(Class value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyType(Type value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeysAreNullFree(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueType(Type value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValuesAreNullFree(boolean value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.containerType)) + "(" + String.valueOf(this.keyType) + "," + String.valueOf(this.valueType) + ")";
    }
}

