/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.Adaptable;
import org.eclipse.ocl.pivot.utilities.Customizable;
import org.eclipse.ocl.pivot.utilities.Option;

public abstract class AbstractCustomizable
implements Adaptable,
Customizable {
    private final @NonNull Map<Option<?>, Object> options = new HashMap();

    protected final @NonNull Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public @NonNull Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.options;
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        Customizable parent2 = this.getParent();
        HashMap result = parent2 != null ? new HashMap(parent2.getOptions()) : new HashMap();
        result.putAll(this.options);
        return result;
    }

    protected abstract @Nullable Customizable getParent();

    @Override
    public <T> T getValue(@NonNull Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result != null) {
            return (T)result;
        }
        Customizable parent2 = this.getParent();
        if (parent2 != null) {
            return parent2.getValue(option);
        }
        return option.getDefaultValue();
    }

    @Override
    public boolean isEnabled(@NonNull Option<@Nullable Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> void putOptions(@NonNull Map<? extends Option<T>, ? extends T> newOptions) {
        Map<Option<?>, Object> myOptions = this.options;
        myOptions.clear();
        myOptions.putAll(newOptions);
    }

    @Override
    public <T> @Nullable T removeOption(@NonNull Option<T> option) {
        @Nullable T result = this.getValue(option);
        this.options.remove(option);
        return result;
    }

    @Override
    public <T> @NonNull Map<Option<T>, T> removeOptions(@NonNull Collection<Option<T>> unwantedOptions) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.options;
        for (Option<T> next : unwantedOptions) {
            if (next == null) continue;
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public <T> void setOption(@NonNull Option<T> option, @Nullable T value) {
        this.options.put(option, value);
    }
}

