/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.examples.eventmanager.CompositeIterable;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallExpKeyedSetImpl
implements OperationCallExpKeyedSet {
    private final Map<OperationCallExp, Iterable<AnnotatedEObject>> map;
    private static final OperationCallExpKeyedSetImpl EMPTY_SET = new OperationCallExpKeyedSetImpl();

    private OperationCallExpKeyedSetImpl() {
        this.map = Collections.emptyMap();
    }

    OperationCallExpKeyedSetImpl(OperationCallExp oce, Iterable<AnnotatedEObject> c) {
        if (c == null) {
            throw new IllegalArgumentException("Must pass a valid, non-null iterable");
        }
        this.map = c.iterator().hasNext() ? Collections.singletonMap(oce, c) : Collections.emptyMap();
    }

    OperationCallExpKeyedSetImpl(Iterable<AnnotatedEObject> c) {
        if (c == null) {
            throw new IllegalArgumentException("Must pass a valid, non-null iterable");
        }
        this.map = !c.iterator().hasNext() ? Collections.emptyMap() : Collections.singletonMap(null, c);
    }

    OperationCallExpKeyedSetImpl(AnnotatedEObject aeo) {
        Set<AnnotatedEObject> aeoAsIterable = Collections.singleton(aeo);
        this.map = Collections.singletonMap(null, aeoAsIterable);
    }

    OperationCallExpKeyedSetImpl(Collection<OperationCallExpKeyedSet> sets) {
        if (sets.isEmpty()) {
            this.map = Collections.emptyMap();
        } else {
            HashMap<OperationCallExp, Iterable<AnnotatedEObject>> myMap = new HashMap<OperationCallExp, Iterable<AnnotatedEObject>>();
            for (OperationCallExpKeyedSet set : sets) {
                for (Map.Entry<OperationCallExp, Iterable<AnnotatedEObject>> entry : set.entrySet()) {
                    Iterable<AnnotatedEObject> entryValue = entry.getValue();
                    if (!entryValue.iterator().hasNext()) continue;
                    HashSet<AnnotatedEObject> mapSet = (HashSet<AnnotatedEObject>)myMap.get(entry.getKey());
                    if (mapSet == null) {
                        mapSet = new HashSet<AnnotatedEObject>();
                        myMap.put(entry.getKey(), mapSet);
                    }
                    for (AnnotatedEObject e : entryValue) {
                        mapSet.add(e);
                    }
                }
            }
            this.map = myMap;
        }
    }

    static OperationCallExpKeyedSetImpl emptySet() {
        return EMPTY_SET;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<AnnotatedEObject> iterator() {
        Iterator<AnnotatedEObject> result;
        if (this.map.size() == 0) {
            Set emptySet = Collections.emptySet();
            result = emptySet.iterator();
        } else {
            result = this.map.size() == 1 ? this.map.values().iterator().next().iterator() : new CompositeIterable(this.map.values()).iterator();
        }
        return result;
    }

    private Iterable<AnnotatedEObject> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Iterable<AnnotatedEObject> getCombinedResultsFor(OperationCallExp oce) {
        Iterable<AnnotatedEObject> result;
        Iterable<AnnotatedEObject> resultForOce = this.get(oce);
        Iterable<AnnotatedEObject> resultForNull = this.get(null);
        if (resultForOce == null || !resultForOce.iterator().hasNext()) {
            result = resultForNull;
        } else if (resultForNull == null || !resultForNull.iterator().hasNext()) {
            result = resultForOce;
        } else {
            HashSet<AnnotatedEObject> resultSet = new HashSet<AnnotatedEObject>();
            for (AnnotatedEObject e : resultForOce) {
                resultSet.add(e);
            }
            for (AnnotatedEObject e : resultForNull) {
                resultSet.add(e);
            }
            result = resultSet;
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        for (AnnotatedEObject e : this) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(e);
        }
        result.append(']');
        return result.toString();
    }

    @Override
    public Iterable<Map.Entry<OperationCallExp, Iterable<AnnotatedEObject>>> entrySet() {
        return this.map.entrySet();
    }
}

