/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import org.eclipse.emf.common.util.URI;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.OperationCallExp;
import org.eclipse.ocl.uml.PropertyCallExp;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class FeatureRedefinitionTest
extends AbstractTestSuite {
    Class c3;
    Operation op3;
    Property attr3;
    Class c2;
    Property attr2;
    Operation op2;
    Class c1;
    Property attr1;
    Operation op1;

    public void testCallOverridingMethod() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        Operation eop = (Operation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op3, (Object)eop);
    }

    public void testCallOverriddenMethod1() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C2).foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        Operation eop = (Operation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op2, (Object)eop);
    }

    public void testCallOverriddenMethod2() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C1).foo()");
        OperationCallExp callExpr = (OperationCallExp)expr;
        Operation eop = (Operation)callExpr.getReferredOperation();
        FeatureRedefinitionTest.assertSame((Object)this.op1, (Object)eop);
    }

    public void testAccessOverridingProperty() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        Property esf = (Property)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr3, (Object)esf);
    }

    public void testAccessOverriddenProperty1() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C2).a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        Property esf = (Property)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr2, (Object)esf);
    }

    public void testAccessOverriddenProperty2() throws Exception {
        this.helper.setContext((Object)this.c3);
        OCLExpression expr = this.helper.createQuery("self.oclAsType(C1).a");
        PropertyCallExp callExpr = (PropertyCallExp)expr;
        Property esf = (Property)callExpr.getReferredProperty();
        FeatureRedefinitionTest.assertSame((Object)this.attr1, (Object)esf);
    }

    protected void setUp() {
        super.setUp();
        UMLFactory f = UMLFactory.eINSTANCE;
        Classifier integer = (Classifier)this.ocl.getEnvironment().getOCLStandardLibrary().getInteger();
        Package p = f.createPackage();
        p.setName("TestPackage");
        resourceSet.createResource(URI.createURI((String)"http:///test.uml")).getContents().add((Object)p);
        this.c1 = p.createOwnedClass("C1", false);
        this.attr1 = this.c1.createOwnedAttribute("a", (Type)integer);
        this.op1 = this.c1.createOwnedOperation("foo", null, null, (Type)integer);
        this.op1.setIsQuery(true);
        this.c2 = p.createOwnedClass("C2", false);
        this.c2.createGeneralization((Classifier)this.c1);
        this.attr2 = this.c2.createOwnedAttribute("a", (Type)integer);
        this.attr2.getRedefinedProperties().add((Object)this.attr1);
        this.op2 = this.c2.createOwnedOperation("foo", null, null, (Type)integer);
        this.op2.setIsQuery(true);
        this.op2.getRedefinedOperations().add((Object)this.op1);
        this.c3 = p.createOwnedClass("C3", false);
        this.c3.createGeneralization((Classifier)this.c2);
        this.attr3 = this.c3.createOwnedAttribute("a", (Type)integer);
        this.attr3.getRedefinedProperties().add((Object)this.attr1);
        this.attr3.getRedefinedProperties().add((Object)this.attr2);
        this.op3 = this.c3.createOwnedOperation("foo", null, null, (Type)integer);
        this.op3.setIsQuery(true);
        this.op3.getRedefinedOperations().add((Object)this.op1);
        this.op3.getRedefinedOperations().add((Object)this.op2);
    }
}

