/*
 * Decompiled with CFR 0.152.
 */
package company.util;

import company.Company;
import company.CompanyPackage;
import company.Department;
import company.Division;
import company.Employee;
import company.Freelance;
import company.Student;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyValidator
extends EObjectValidator {
    public static final CompanyValidator INSTANCE = new CompanyValidator();
    public static final String DIAGNOSTIC_SOURCE = "company";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String EMPLOYEE__UNIQUE_NAMES__EEXPRESSION = "Employee.allInstances()->forAll(e | e <> self implies e.name <> self.name)";
    protected static final String EMPLOYEE__BOSS_IS_OLDEST__EEXPRESSION = "self.age <= self.employer.boss.age";
    protected static final String EMPLOYEE__DIV_BOSS_SECRETARY__EEXPRESSION = "if self.directed->isEmpty() then\r\nself.secretary.oclIsUndefined()\r\nelse\r\nnot self.secretary.oclIsUndefined()\r\nendif";
    protected static final String EMPLOYEE__SECRETARY_OLDER_THAN_BOSS__EEXPRESSION = "if self.directed->notEmpty() and\r\nnot self.secretary.oclIsUndefined() then\r\nself.age < self.secretary.age \r\nelse true\r\nendif";
    protected static final String EMPLOYEE__BOSS10_YEARS_OLDER_THAN_EMPLOYEE__EEXPRESSION = "self.age + 10 <= self.employer.boss.age";
    protected static final String EMPLOYEE__SECRETARY10_YEARS_OLDER_THAN_BOSS__EEXPRESSION = "if self.directed->notEmpty() and\r\nnot self.secretary.oclIsUndefined() then\r\nself.age + 10 < self.secretary.age \r\nelse true\r\nendif";
    protected static final String DEPARTMENT__NOT_BOSS_FREELANCE__EEXPRESSION = "not (self.boss.oclIsTypeOf(Freelance))";
    protected static final String DEPARTMENT__OLD_EMPLOYEE__EEXPRESSION = "self.employee->exists(e | e.age > 45)";
    protected static final String DEPARTMENT__MAX_JUNIORS__EEXPRESSION = "self.employee->select(e|e.age < 25)->size()\r\n<self.maxJuniors";
    protected static final String DEPARTMENT__BOSS_HIGHEST_SALARY__EEXPRESSION = "self.employee->select(e|e.salary >= self.boss.salary)->size() <= 1";
    protected static final String DEPARTMENT__BOSS10_YEARS_OLDER_THAN_JUNIOR__EEXPRESSION = "let t:Tuple(boss:Employee,junior:Employee)=\r\nTuple{boss=self.boss, junior=self.employee->sortedBy(age)->first()} in\r\nt.boss.age > t.junior.age + 10";
    protected static final String DEPARTMENT__BUDGET_RESTRICTION__EEXPRESSION = "self.calcExpenses() <= self.budget";
    protected static final String DEPARTMENT__MAX_JUNIORS_WARNING__EEXPRESSION = "if self.maxJuniors > 1\r\nthen\r\nself.employee->select(e|e.age < 25)->size()\r\n<self.maxJuniors - 1\r\nelse\r\ntrue\r\nendif";
    protected static final String DEPARTMENT__DEPARTMENT_MUST_HAVE_DIVISION__EEXPRESSION = "self.department2division->notEmpty()";
    protected static final String FREELANCE__VALID_ASSIGNMENT__EEXPRESSION = "self.assignment >= 5 and self.assignment <= 30";
    protected static final String FREELANCE__VALID_ASSIGNMENT_WARNING__EEXPRESSION = "self.assignment >= 5 and self.assignment <= 40";
    protected static final String FREELANCE__STUDENT_AND_FREELANCES_AGE__EEXPRESSION = "self.age < 40";
    protected static final String DIVISION__NASTY__EEXPRESSION = "self.department->collect(d| \r\nd.employee->including(d.boss)).salary->sum() < budget";
    protected static final String DIVISION__LIMIT_EMPLOYEES_OF_THE_MONTH__EEXPRESSION = "self.employeesOfTheMonth->size() <= self.department->size()";
    protected static final String DIVISION__NESTED_DERIVATION__EEXPRESSION = "self.numberEmployeesOfTheMonth <= self.department->size()";
    protected static final String STUDENT__STUDENT_AND_FREELANCES_AGE__EEXPRESSION = "self.age < 40";
    protected static final String COMPANY__EOTM_DELTA_MAX__EEXPRESSION = "self.eotmDelta <= 5";

    protected EPackage getEPackage() {
        return CompanyPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateEmployee((Employee)value, diagnostics, context);
            }
            case 1: {
                return this.validateDepartment((Department)value, diagnostics, context);
            }
            case 2: {
                return this.validateFreelance((Freelance)value, diagnostics, context);
            }
            case 3: {
                return this.validateDivision((Division)value, diagnostics, context);
            }
            case 4: {
                return this.validateStudent((Student)value, diagnostics, context);
            }
            case 5: {
                return this.validateCompany((Company)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateEmployee(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(employee, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(employee, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_UniqueNames(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_BossIsOldest(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_divBossSecretary(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_secretaryOlderThanBoss(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Boss10YearsOlderThanEmployee(employee, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Secretary10YearsOlderThanBoss(employee, diagnostics, context);
        }
        return result;
    }

    public boolean validateEmployee_UniqueNames(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "UniqueNames", EMPLOYEE__UNIQUE_NAMES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_BossIsOldest(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "BossIsOldest", EMPLOYEE__BOSS_IS_OLDEST__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_divBossSecretary(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "divBossSecretary", EMPLOYEE__DIV_BOSS_SECRETARY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_secretaryOlderThanBoss(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "secretaryOlderThanBoss", EMPLOYEE__SECRETARY_OLDER_THAN_BOSS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_Boss10YearsOlderThanEmployee(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "Boss10YearsOlderThanEmployee", EMPLOYEE__BOSS10_YEARS_OLDER_THAN_EMPLOYEE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEmployee_Secretary10YearsOlderThanBoss(Employee employee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.EMPLOYEE, employee, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "Secretary10YearsOlderThanBoss", EMPLOYEE__SECRETARY10_YEARS_OLDER_THAN_BOSS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(department, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(department, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_NotBossFreelance(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_OldEmployee(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_MaxJuniors(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_BossHighestSalary(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_boss10YearsOlderThanJunior(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_BudgetRestriction(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_MaxJuniorsWarning(department, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDepartment_departmentMustHaveDivision(department, diagnostics, context);
        }
        return result;
    }

    public boolean validateDepartment_NotBossFreelance(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "NotBossFreelance", DEPARTMENT__NOT_BOSS_FREELANCE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_OldEmployee(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "OldEmployee", DEPARTMENT__OLD_EMPLOYEE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_MaxJuniors(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MaxJuniors", DEPARTMENT__MAX_JUNIORS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_BossHighestSalary(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "BossHighestSalary", DEPARTMENT__BOSS_HIGHEST_SALARY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_boss10YearsOlderThanJunior(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "boss10YearsOlderThanJunior", DEPARTMENT__BOSS10_YEARS_OLDER_THAN_JUNIOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_BudgetRestriction(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "BudgetRestriction", DEPARTMENT__BUDGET_RESTRICTION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_MaxJuniorsWarning(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "MaxJuniorsWarning", DEPARTMENT__MAX_JUNIORS_WARNING__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDepartment_departmentMustHaveDivision(Department department, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DEPARTMENT, department, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "departmentMustHaveDivision", DEPARTMENT__DEPARTMENT_MUST_HAVE_DIVISION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFreelance(Freelance freelance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(freelance, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(freelance, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_UniqueNames(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_BossIsOldest(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_divBossSecretary(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_secretaryOlderThanBoss(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Boss10YearsOlderThanEmployee(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Secretary10YearsOlderThanBoss(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFreelance_ValidAssignment(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFreelance_ValidAssignmentWarning(freelance, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFreelance_StudentAndFreelancesAge(freelance, diagnostics, context);
        }
        return result;
    }

    public boolean validateFreelance_ValidAssignment(Freelance freelance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.FREELANCE, freelance, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValidAssignment", FREELANCE__VALID_ASSIGNMENT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFreelance_ValidAssignmentWarning(Freelance freelance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.FREELANCE, freelance, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "ValidAssignmentWarning", FREELANCE__VALID_ASSIGNMENT_WARNING__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFreelance_StudentAndFreelancesAge(Freelance freelance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.FREELANCE, freelance, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "StudentAndFreelancesAge", "self.age < 40", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDivision(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(division, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(division, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDivision_nasty(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDivision_limitEmployeesOfTheMonth(division, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDivision_nestedDerivation(division, diagnostics, context);
        }
        return result;
    }

    public boolean validateDivision_nasty(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DIVISION, division, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "nasty", DIVISION__NASTY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDivision_limitEmployeesOfTheMonth(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DIVISION, division, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "limitEmployeesOfTheMonth", DIVISION__LIMIT_EMPLOYEES_OF_THE_MONTH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDivision_nestedDerivation(Division division, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.DIVISION, division, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "nestedDerivation", DIVISION__NESTED_DERIVATION__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateStudent(Student student, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(student, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(student, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_UniqueNames(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_BossIsOldest(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_divBossSecretary(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_secretaryOlderThanBoss(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Boss10YearsOlderThanEmployee(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEmployee_Secretary10YearsOlderThanBoss(student, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStudent_StudentAndFreelancesAge(student, diagnostics, context);
        }
        return result;
    }

    public boolean validateStudent_StudentAndFreelancesAge(Student student, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.STUDENT, student, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "StudentAndFreelancesAge", "self.age < 40", 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCompany(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(company, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(company, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(company, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompany_eotmDeltaMax(company, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompany_eotmDeltaMax(Company company, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompanyPackage.Literals.COMPANY, company, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "eotmDeltaMax", COMPANY__EOTM_DELTA_MAX__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

