/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.markup;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.context.OperationContext;
import org.eclipse.ocl.pivot.internal.context.PropertyContext;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.HTMLBuffer;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.utilities.OCLHelper;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.xtext.markup.MarkupToString;
import org.eclipse.ocl.xtext.markup.MarkupUtils;
import org.eclipse.ocl.xtext.markupcs.BulletElement;
import org.eclipse.ocl.xtext.markupcs.CompoundElement;
import org.eclipse.ocl.xtext.markupcs.FigureElement;
import org.eclipse.ocl.xtext.markupcs.FigureRefElement;
import org.eclipse.ocl.xtext.markupcs.FontElement;
import org.eclipse.ocl.xtext.markupcs.FootnoteElement;
import org.eclipse.ocl.xtext.markupcs.HeadingElement;
import org.eclipse.ocl.xtext.markupcs.MarkupElement;
import org.eclipse.ocl.xtext.markupcs.NewLineElement;
import org.eclipse.ocl.xtext.markupcs.NullElement;
import org.eclipse.ocl.xtext.markupcs.OCLCodeElement;
import org.eclipse.ocl.xtext.markupcs.OCLEvalElement;
import org.eclipse.ocl.xtext.markupcs.OCLTextElement;
import org.eclipse.ocl.xtext.markupcs.TextElement;
import org.eclipse.ocl.xtext.markupcs.util.MarkupSwitch;

public class MarkupToHTML
extends MarkupSwitch<HTMLBuffer> {
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    protected final @Nullable Object context;
    protected final @NonNull HTMLBuffer s = new HTMLBuffer();

    public static String toString(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Object context, @NonNull MarkupElement element) throws Exception {
        MarkupToHTML toString = new MarkupToHTML(environmentFactory, context);
        try {
            return String.valueOf(toString.doSwitch(element));
        }
        catch (InvalidMarkupException e) {
            throw (Exception)e.getCause();
        }
    }

    public MarkupToHTML(@NonNull EnvironmentFactoryInternal environmentFactory, @Nullable Object context) {
        this.environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory;
        this.context = context;
    }

    @Override
    public HTMLBuffer caseBulletElement(BulletElement object) {
        Integer level = Integer.valueOf(object.getLevel());
        this.s.startBulletLevel(level);
        this.caseCompoundElement(object);
        this.s.endBulletLevel(level);
        return this.s;
    }

    @Override
    public HTMLBuffer caseCompoundElement(CompoundElement object) {
        for (MarkupElement element : object.getElements()) {
            this.doSwitch(element);
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseFigureElement(FigureElement object) {
        if (object.getDef() != null) {
            this.s.appendLabelDef(object.getDef());
        }
        this.s.appendFigure(object.getSrc(), object.getAlt(), object.getRequiredWidth(), object.getRequiredHeight());
        return this.s;
    }

    @Override
    public HTMLBuffer caseFigureRefElement(FigureRefElement object) {
        FigureElement ref = object.getRef();
        if (ref.eIsProxy()) {
            String message = "Unresolved proxy '" + ((InternalEObject)ref).eProxyURI() + "'";
            throw new InvalidMarkupException(new IllegalStateException(message));
        }
        this.s.appendLabelRef(ref.getDef());
        return this.s;
    }

    @Override
    public HTMLBuffer caseFontElement(FontElement object) {
        String font = object.getFont();
        String htmlFont = "b".equals(font) ? "b" : ("e".equals(font) ? "i" : "???");
        this.s.startFontName(htmlFont);
        this.caseCompoundElement(object);
        this.s.endFontName(htmlFont);
        return this.s;
    }

    @Override
    public HTMLBuffer caseFootnoteElement(FootnoteElement object) {
        this.s.startFootnote();
        this.caseCompoundElement(object);
        this.s.endFootnote();
        return this.s;
    }

    @Override
    public HTMLBuffer caseHeadingElement(HeadingElement object) {
        String level = object.getLevel();
        if (level == null) {
            level = "1";
        }
        this.s.startHeadingLevel(level);
        this.caseCompoundElement(object);
        this.s.endHeadingLevel(level);
        return this.s;
    }

    @Override
    public HTMLBuffer caseNewLineElement(NewLineElement object) {
        assert (object != null);
        int newLines = MarkupUtils.getNewlineCount(object);
        if (newLines <= 1) {
            this.s.append("\n");
        } else {
            this.s.append("\n");
            this.s.endParagraph();
            this.s.startParagraph();
            this.s.append("\n");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseNullElement(NullElement object) {
        this.s.append('[');
        this.caseCompoundElement(object);
        this.s.append(']');
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLCodeElement(OCLCodeElement object) {
        this.s.startFontName("pre");
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            try {
                ExpressionInOCL query = this.createQuery(oclString);
                String text = PrettyPrinter.print((Element)query);
                this.s.append(text);
            }
            catch (ParserException e) {
                throw new InvalidMarkupException((Exception)((Object)e));
            }
        }
        finally {
            this.s.endFontName("pre");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLEvalElement(OCLEvalElement object) {
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            OCLInternal ocl = this.environmentFactory.createOCL();
            ExpressionInOCL query = this.createQuery(oclString);
            Object value = ocl.evaluate(this.context, query);
            this.s.append(String.valueOf(value));
            ocl.dispose();
        }
        catch (ParserException e) {
            throw new InvalidMarkupException((Exception)((Object)e));
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseOCLTextElement(OCLTextElement object) {
        this.s.startFontName("tt");
        EList<MarkupElement> elements = object.getElements();
        assert (elements != null);
        String oclString = MarkupToString.toString(elements);
        try {
            try {
                ExpressionInOCL query = this.createQuery(oclString);
                PrettyPrintOptions.Global options = PrettyPrinter.createOptions(null);
                options.setLinelength(Integer.MAX_VALUE);
                String text = PrettyPrinter.print((Element)query, (PrettyPrintOptions)options);
                this.s.append(text);
            }
            catch (ParserException e) {
                throw new InvalidMarkupException((Exception)((Object)e));
            }
        }
        finally {
            this.s.endFontName("tt");
        }
        return this.s;
    }

    @Override
    public HTMLBuffer caseTextElement(TextElement object) {
        for (String text : object.getText()) {
            int iMax = text.length();
            if (iMax <= 0) continue;
            char c = text.charAt(0);
            if (c == ' ' || c == '\t') {
                this.s.append(' ');
                continue;
            }
            int i = 0;
            while (i < iMax) {
                if ((c = text.charAt(i++)) == '\\' && i < iMax) {
                    c = text.charAt(i++);
                }
                this.s.append(c);
            }
        }
        return this.s;
    }

    protected @NonNull ExpressionInOCL createQuery(@NonNull String oclString) throws ParserException {
        Class parserContext2 = null;
        OCLInternal ocl = this.environmentFactory.createOCL();
        try {
            if (this.context instanceof Operation) {
                Operation operationContext = (Operation)this.context;
                OperationContext parserContext = new OperationContext(ocl.getEnvironmentFactory(), null, operationContext, "result");
                ExpressionInOCL expressionInOCL = parserContext.parse((EObject)operationContext.getOwningClass(), oclString);
                return expressionInOCL;
            }
            if (this.context instanceof Property) {
                Property propertyContext = (Property)this.context;
                PropertyContext parserContext = new PropertyContext(ocl.getEnvironmentFactory(), null, propertyContext);
                ExpressionInOCL expressionInOCL = parserContext.parse((EObject)propertyContext.getOwningClass(), oclString);
                return expressionInOCL;
            }
            if (this.context instanceof Class) {
                Class classContext = (Class)this.context;
                ClassContext parserContext = new ClassContext(ocl.getEnvironmentFactory(), null, classContext, null);
                ExpressionInOCL expressionInOCL = parserContext.parse((EObject)classContext, oclString);
                return expressionInOCL;
            }
            if (this.context instanceof EObject) {
                Resource resource;
                EClass eClass = ((EObject)this.context).eClass();
                String name = eClass.getName();
                assert (name != null);
                parserContext2 = this.environmentFactory.getASClass(name);
                if (parserContext2 == null && (resource = eClass.eResource()) != null) {
                    Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)resource, (EnvironmentFactoryInternal)this.environmentFactory);
                    parserContext2 = ecore2as.getCreated(Class.class, (EObject)eClass);
                }
            }
            OCLHelper helper = ocl.createOCLHelper(parserContext2);
            ExpressionInOCL expressionInOCL = helper.createQuery(oclString);
            return expressionInOCL;
        }
        finally {
            ocl.dispose();
        }
    }

    @Override
    public HTMLBuffer defaultCase(EObject object) {
        this.s.append("<Unsupported ");
        this.s.append(object.eClass().getName());
        this.s.append(">");
        return this.s;
    }

    public String toString() {
        return this.s.toString();
    }

    public static class InvalidMarkupException
    extends RuntimeException {
        public InvalidMarkupException(Exception e) {
            super(e);
        }
    }
}

