/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.xtend.parser.ParseFacade;
import org.eclipse.xtend.backend.BackendFacade;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.FunctionDefContextInternal;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.OldExpressionConverter;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendGlobalVarOperations;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendLibContributor;
import org.eclipse.xtend.middleend.xtend.plugin.OldCheckRegistryFactory;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XtendBackendFacade {
    private final String _xtendFile;
    private final MiddleEnd _middleEnd;
    private final Collection<MetaModel> _mms;

    public static Object evaluateExpression(String expression, Collection<MetaModel> mms, Map<String, Object> localVars) {
        return XtendBackendFacade.evaluateExpression(expression, mms, localVars, null);
    }

    public static Object evaluateExpression(String expression, Collection<MetaModel> mms, Map<String, Object> localVars, Map<String, Object> globalVars) {
        return XtendBackendFacade.evaluateExpression(expression, null, null, mms, localVars, globalVars, null);
    }

    public static Object evaluateExpression(String expression, String initialXtendFileName, String fileEncoding, Collection<MetaModel> mms, Map<String, Object> localVars) {
        return XtendBackendFacade.evaluateExpression(expression, initialXtendFileName, fileEncoding, mms, localVars, null, null);
    }

    public static Object evaluateExpression(String expression, String initialXtendFileName, String fileEncoding, Collection<MetaModel> mms, Map<String, Object> localVars, Map<String, Object> globalVars, List<String> adviceResources) {
        return XtendBackendFacade.createForFile(initialXtendFileName, fileEncoding, mms).evaluateExpression(expression, localVars, globalVars, adviceResources);
    }

    public Object evaluateExpression(String expression, Map<String, Object> localVars) {
        return this.evaluateExpression(expression, localVars, null, null);
    }

    public Object evaluateExpression(String expression, Map<String, Object> localVars, Map<String, Object> globalVars, List<String> adviceResources) {
        if (localVars == null) {
            localVars = new HashMap<String, Object>();
        }
        if (globalVars == null) {
            globalVars = new HashMap<String, Object>();
        }
        if (adviceResources == null) {
            adviceResources = new ArrayList<String>();
        }
        for (String a : adviceResources) {
            this._middleEnd.applyAdvice(a);
        }
        Expression oldAst = ParseFacade.expression((String)expression);
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        for (MetaModel mm : this._mms) {
            ctx.registerMetaModel(mm);
        }
        for (String varName : localVars.keySet()) {
            ctx = (ExecutionContextImpl)ctx.cloneWithVariable(new Variable(varName, (Object)ctx.getType(localVars.get(varName))));
        }
        TypeToBackendType typeConverter = new TypeToBackendType(this._middleEnd.getTypesystem(), (ExecutionContext)ctx);
        ExpressionBase newAst = new OldExpressionConverter((ExecutionContext)ctx, typeConverter, "<no file>").convert(oldAst);
        this._middleEnd.getExecutionContext().setFunctionDefContext(this.createFdc());
        this._middleEnd.getExecutionContext().getLocalVarContext().getLocalVars().putAll(localVars);
        this._middleEnd.getExecutionContext().getContributionStateContext().storeState(XtendGlobalVarOperations.GLOBAL_VAR_VALUES_KEY, globalVars);
        return newAst.evaluate(this._middleEnd.getExecutionContext());
    }

    private FunctionDefContext createFdc() {
        if (this._xtendFile != null) {
            return this._middleEnd.getFunctions(this._xtendFile);
        }
        FunctionDefContextInternal result = this._middleEnd.createEmptyFdc();
        for (NamedFunction f : new XtendLibContributor(this._middleEnd).getContributedFunctions()) {
            result.register(f, false);
        }
        return result;
    }

    public static Object invokeXtendFunction(String xtendFileName, String fileEncoding, Collection<MetaModel> mms, QualifiedName functionName, Object ... parameters) {
        return XtendBackendFacade.createForFile(xtendFileName, fileEncoding, mms).invokeXtendFunction(functionName, parameters);
    }

    public Object invokeXtendFunction(QualifiedName functionName, Object ... parameters) {
        FunctionDefContext fdc = this._middleEnd.getFunctions(this._xtendFile);
        org.eclipse.xtend.backend.common.ExecutionContext ctx = BackendFacade.createExecutionContext((FunctionDefContext)fdc, (BackendTypesystem)this._middleEnd.getTypesystem(), (boolean)true);
        return fdc.invoke(ctx, functionName, Arrays.asList(parameters));
    }

    public static XtendBackendFacade createForFile(String xtendFileName, String fileEncoding, Collection<MetaModel> mms) {
        return new XtendBackendFacade(xtendFileName, fileEncoding, mms);
    }

    private Map<Class<?>, Object> getSpecificParameters(String fileEncoding, Collection<MetaModel> mms) {
        fileEncoding = OldHelper.normalizedFileEncoding(fileEncoding);
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.getResourceManager().setFileEncoding(fileEncoding);
        for (MetaModel mm : mms) {
            ctx.registerMetaModel(mm);
        }
        HashMap result = new HashMap();
        result.put(OldXtendRegistryFactory.class, ctx);
        result.put(OldCheckRegistryFactory.class, ctx);
        return result;
    }

    private XtendBackendFacade(String xtendFileName, String fileEncoding, Collection<MetaModel> mms) {
        if (mms == null) {
            mms = new ArrayList<MetaModel>();
        }
        this._xtendFile = OldHelper.normalizeXtendResourceName(xtendFileName);
        this._mms = mms;
        this._middleEnd = MiddleEndFactory.canCreateFromExtentions() ? MiddleEndFactory.createFromExtensions((BackendTypesystem)OldHelper.guessTypesystem(mms), this.getSpecificParameters(fileEncoding, mms)) : MiddleEndFactory.create((BackendTypesystem)OldHelper.guessTypesystem(mms), (List)LanguageContributor.INSTANCE.getFreshMiddleEnds(this.getSpecificParameters(fileEncoding, mms)));
    }

    public FunctionDefContext getFunctionDefContext() {
        return this._middleEnd.getFunctions(this._xtendFile);
    }
}

