/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.editor.scanning;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.xpand.ui.XpandEditorPlugin;
import org.eclipse.xpand.ui.editor.color.ColorProvider;
import org.eclipse.xtend.shared.ui.Activator;

public abstract class AbstractXpandRuleBasedScanner
extends RuleBasedScanner {
    protected Token terminals;
    protected Token keyword;
    protected Token string;
    protected Token text;
    protected Token define;
    protected Token comment;
    protected Token other;

    public AbstractXpandRuleBasedScanner() {
        this.initialize();
        this.setDefaultReturnToken((IToken)this.other);
    }

    public synchronized void initialize() {
        IPreferenceStore aPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (this.terminals == null) {
            this.terminals = new Token(null);
        }
        this.terminals.setData((Object)this.getAttribute(aPreferenceStore, "xpd_terminals"));
        if (this.keyword == null) {
            this.keyword = new Token(null);
        }
        this.keyword.setData((Object)this.getAttribute(aPreferenceStore, "xpd_keywords"));
        if (this.string == null) {
            this.string = new Token(null);
        }
        this.string.setData((Object)this.getAttribute(aPreferenceStore, "xpd_string"));
        if (this.define == null) {
            this.define = new Token(null);
        }
        this.define.setData((Object)this.getAttribute(aPreferenceStore, "xpd_define"));
        if (this.text == null) {
            this.text = new Token(null);
        }
        this.text.setData((Object)this.getAttribute(aPreferenceStore, "xpd_text"));
        if (this.comment == null) {
            this.comment = new Token(null);
        }
        this.comment.setData((Object)this.getAttribute(aPreferenceStore, "xpd_comment"));
        if (this.other == null) {
            this.other = new Token(null);
        }
        this.other.setData((Object)this.getAttribute(aPreferenceStore, "xpd_other"));
    }

    private TextAttribute getAttribute(IPreferenceStore store, String name) {
        ColorProvider provider = XpandEditorPlugin.getColorProvider();
        Color fgColor = provider.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(name) + ".fgcolor")));
        int textStyle = store.getInt(String.valueOf(name) + ".fstyle");
        return new TextAttribute(fgColor, null, textStyle);
    }
}

