/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.common.EfficientLazyString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHelper {
    private static final char[] FILE_DELIMITER = new char[]{'\\', '/'};
    private static int _cvNumerOfFilesRead = 1;
    private static int _cvSize = 2000;

    private static void getAllFilesInternal(File aPath, FilenameFilter filter, List<File> fileList) {
        File[] allFiles = aPath.listFiles(filter);
        int i = 0;
        while (i < allFiles.length) {
            if (allFiles[i].isDirectory()) {
                FileHelper.getAllFilesInternal(allFiles[i], filter, fileList);
            } else {
                fileList.add(allFiles[i]);
            }
            ++i;
        }
    }

    public static String read(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("Fileparameter should not be null!");
        }
        return FileHelper.read(new File(filename), null);
    }

    public static String read(String filename, String encoding) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("Fileparameter should not be null!");
        }
        return FileHelper.read(new File(filename), encoding);
    }

    public static String read(File file, String encoding) throws IOException {
        int len;
        if (file == null) {
            throw new IllegalArgumentException("Fileparameter should not be null!");
        }
        if (!file.isFile()) {
            throw new IOException(String.valueOf(file.getPath()) + " is not a file!");
        }
        if (!file.canRead()) {
            throw new IOException(String.valueOf(file.getPath()) + " is not a readable!");
        }
        StringBuffer body = new StringBuffer();
        InputStreamReader fileReader = null;
        fileReader = encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        int size = (int)Math.floor((double)_cvSize / (double)_cvNumerOfFilesRead);
        ++_cvNumerOfFilesRead;
        char[] chars = new char[size];
        while ((len = fileReader.read(chars)) != -1) {
            _cvSize += len;
            body.append(chars, 0, len);
        }
        ((Reader)fileReader).close();
        return body.toString();
    }

    public static String read(Reader reader) throws IOException {
        int len;
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null!");
        }
        StringBuffer aString = new StringBuffer();
        int size = (int)Math.floor((double)_cvSize / (double)_cvNumerOfFilesRead);
        ++_cvNumerOfFilesRead;
        char[] chars = new char[size];
        while ((len = reader.read(chars)) != -1) {
            _cvSize += len;
            aString.append(chars, 0, len);
        }
        reader.close();
        return aString.toString();
    }

    public static void write(Writer writer, EfficientLazyString text) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null!");
        }
        StringReader reader = new StringReader(text.toString());
        FileHelper.write(writer, reader);
    }

    public static void write(Writer writer, CharSequence text) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null!");
        }
        StringReader reader = new StringReader(text.toString());
        FileHelper.write(writer, reader);
    }

    public static void write(String path, CharSequence text) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null!");
        }
        FileWriter writer = new FileWriter(new File(path));
        StringReader reader = new StringReader(text.toString());
        FileHelper.write((Writer)writer, reader);
    }

    public static void write(Writer writer, Reader reader) throws IOException {
        int len;
        if (writer == null) {
            throw new IllegalArgumentException("Writer must not be null!");
        }
        char[] chars = new char[4096];
        while ((len = reader.read(chars)) != -1) {
            _cvSize += len;
            writer.write(chars, 0, len);
        }
        reader.close();
        writer.close();
    }

    public static File[] getAllFiles(File file, FilenameFilter filter) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException(String.valueOf(file.getPath()) + " is not a directory!");
        }
        ArrayList<File> returnList = new ArrayList<File>();
        FileHelper.getAllFilesInternal(file, filter, returnList);
        return returnList.toArray(new File[returnList.size()]);
    }

    public static File[] getAllFilesInHierarchy(String basePath, FilenameFilter filter) throws IOException {
        return FileHelper.getAllFiles(new File(basePath), filter);
    }

    public static String normalizePath(String filename) {
        int i = 0;
        while (i < FILE_DELIMITER.length) {
            filename = filename.replace(FILE_DELIMITER[i], File.separatorChar);
            ++i;
        }
        return filename;
    }
}

