/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.parser;

import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.jet.internal.parser.JETReader;
import org.eclipse.jet.internal.parser.LineInfo;

public final class JETMark {
    protected int cursor;
    protected int fileid;
    protected String baseDir;
    protected char[] stream = null;
    protected LineInfo[] lineInfo = null;
    protected Stack includeStack = null;
    protected String encoding = null;
    protected JETReader reader;

    JETMark(JETReader reader, char[] inStream, int fileid, String inBaseDir, String inEncoding) {
        this.reader = reader;
        this.stream = inStream;
        this.cursor = 0;
        this.lineInfo = LineInfo.calculateLines(inStream);
        this.fileid = fileid;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.includeStack = new Stack();
    }

    JETMark(JETMark other) {
        this.reader = other.reader;
        this.stream = other.stream;
        this.fileid = other.fileid;
        this.cursor = other.cursor;
        this.lineInfo = other.lineInfo;
        this.baseDir = other.baseDir;
        this.encoding = other.encoding;
        this.includeStack = new Stack();
        int i = 0;
        while (i < other.includeStack.size()) {
            this.includeStack.addElement(other.includeStack.elementAt(i));
            ++i;
        }
    }

    public void pushStream(char[] inStream, int inFileid, String inBaseDir, String inEncoding) {
        this.includeStack.push(new IncludeState(this.cursor, this.lineInfo, this.fileid, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.fileid = inFileid;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.stream = inStream;
        this.lineInfo = LineInfo.calculateLines(inStream);
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState state = (IncludeState)this.includeStack.pop();
        this.cursor = state.cursor;
        this.lineInfo = state.lineInfo;
        this.fileid = state.fileid;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return true;
    }

    public String getFile() {
        return this.reader.getFile(this.fileid);
    }

    public String getBaseURI() {
        return this.reader.getBaseURI(this.fileid);
    }

    public String getLocalFile() {
        String file = this.reader.getFile(this.fileid);
        if (file.startsWith("file:/")) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile iFile = workspaceRoot.getFileForLocation((IPath)new Path(file.substring(6)));
            file = iFile.getFullPath().toString();
        }
        return file;
    }

    public int getFileId() {
        return this.fileid;
    }

    public int getCursor() {
        return this.cursor;
    }

    public String toShortString() {
        return "(" + this.getLine() + "," + this.getCol() + ")";
    }

    public String toString() {
        return String.valueOf(this.getLocalFile()) + "(" + this.getLine() + "," + this.getCol() + ")";
    }

    public String format(String key) {
        return CodeGenPlugin.getPlugin().getString(key, new Object[]{this.getLocalFile(), new Integer(this.getLine() + 1), new Integer(this.getCol() + 1), new Integer(this.cursor)});
    }

    public boolean equals(Object other) {
        if (other instanceof JETMark) {
            JETMark m = (JETMark)other;
            return this.reader == m.reader && this.fileid == m.fileid && this.cursor == m.cursor && this.getLine() == m.getLine() && this.getCol() == m.getCol();
        }
        return false;
    }

    public int getLine() {
        return LineInfo.getLineNo(this.lineInfo, this.cursor);
    }

    public int getCol() {
        int lineIndex = this.getLine() - 1;
        if (lineIndex < this.lineInfo.length) {
            return this.cursor - this.lineInfo[lineIndex].getStart() + 1;
        }
        return this.cursor - (this.lineInfo[this.lineInfo.length - 1].getEnd() + this.lineInfo[this.lineInfo.length - 1].getDelimiter().length()) + 1;
    }

    class IncludeState {
        int cursor;
        int fileid;
        String baseDir;
        String encoding;
        char[] stream = null;
        private final LineInfo[] lineInfo;

        IncludeState(int inCursor, LineInfo[] inLineInfo, int inFileid, String inBaseDir, String inEncoding, char[] inStream) {
            this.cursor = inCursor;
            this.lineInfo = inLineInfo;
            this.fileid = inFileid;
            this.baseDir = inBaseDir;
            this.encoding = inEncoding;
            this.stream = inStream;
        }
    }
}

