/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jet.internal.compiler.CompilerErrorUtil;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.parser.JETCoreElement;
import org.eclipse.jet.internal.parser.JETMark;
import org.eclipse.jet.internal.parser.JETParseEventListener;
import org.eclipse.jet.internal.parser.JETParseEventListener2;
import org.eclipse.jet.internal.parser.JETParser;
import org.eclipse.jet.internal.parser.JETReader;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;

public class XMLElementDelegate
implements JETCoreElement {
    private static final String XML_TAG_CLOSE = ">";
    private static final String SLASH = "/";
    private static final String XML_CLOSE_TAG_OPEN = "</";
    private static final String XML_TAG_OPEN = "<";

    public boolean accept(JETParseEventListener listener, JETReader reader, JETParser parser) throws JETException {
        if (!(listener instanceof JETParseEventListener2)) {
            return false;
        }
        JETParseEventListener2 jet2Listener = (JETParseEventListener2)listener;
        String elementOpen = XML_TAG_OPEN;
        if (!reader.matches(elementOpen)) {
            return false;
        }
        JETMark start = reader.mark();
        reader.advance(elementOpen.length());
        boolean isEndTag = false;
        boolean isEmptyTag = false;
        if (reader.matches(SLASH)) {
            isEndTag = true;
            reader.advance(1);
            elementOpen = XML_CLOSE_TAG_OPEN;
        }
        String tagName = reader.parseToken(false, false);
        boolean knownInvalidTagName = jet2Listener.isKnownInvalidTagName(tagName);
        if (!jet2Listener.isKnownTag(tagName) && !knownInvalidTagName) {
            reader.reset(start);
            return false;
        }
        JETMark interiorStartMark = reader.mark();
        JETMark endTagMark = reader.skipUntil(XML_TAG_CLOSE);
        if (endTagMark == null) {
            CompilerErrorUtil.recordUnterminatedElement(jet2Listener, XML_TAG_CLOSE, start, reader);
            return true;
        }
        reader.reset(interiorStartMark);
        LinkedHashMap<String, String> attributeMap = Collections.EMPTY_MAP;
        if (isEndTag) {
            reader.skipSpaces();
        } else {
            attributeMap = new LinkedHashMap<String, String>();
            reader.skipSpaces();
            while (reader.peekChar() != 62 && reader.peekChar() != 47) {
                JETMark[] attrMarks = reader.parseXmlAttribute();
                String name = new String(reader.getChars(attrMarks[0], attrMarks[1]));
                String value = new String(reader.getChars(attrMarks[3], attrMarks[4]));
                if (attributeMap.containsKey(name)) {
                    String msg = JET2Messages.XMLElementDelegate_DuplicateAttribute;
                    jet2Listener.recordProblem(ParseProblemSeverity.ERROR, 8, msg, null, attrMarks[0].getCursor(), attrMarks[4].getCursor(), attrMarks[0].getLine(), attrMarks[0].getCol());
                } else {
                    attributeMap.put(name, value.substring(1, value.length() - 1));
                }
                reader.skipSpaces();
            }
        }
        if (reader.peekChar() == 47 && !isEndTag) {
            reader.nextChar();
            isEmptyTag = true;
        }
        if (reader.peekChar() != 62) {
            CompilerErrorUtil.recordUnterminatedElement(jet2Listener, XML_TAG_CLOSE, start, reader);
        }
        reader.nextChar();
        JETMark stop = reader.mark();
        if (knownInvalidTagName) {
            jet2Listener.recordProblem(ParseProblemSeverity.WARNING, 16, JET2Messages.XMLElementDelegate_UnknownXMLTag, new Object[]{tagName}, start.getCursor(), stop.getCursor(), start.getLine(), start.getCol());
            reader.reset(start);
            return false;
        }
        if (isEmptyTag) {
            jet2Listener.handleXMLEmptyTag(tagName, start, stop, attributeMap);
        } else if (isEndTag) {
            jet2Listener.handleXMLEndTag(tagName, start, stop);
        } else {
            jet2Listener.handleXMLStartTag(tagName, start, stop, attributeMap);
        }
        return true;
    }
}

