/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.CustomTagFactory;
import org.eclipse.jet.internal.taglib.ExtensionTagLibraryImpl;
import org.eclipse.jet.internal.taglib.TagAttributeDefinitionImpl;
import org.eclipse.jet.internal.taglib.TagDefinitionImpl;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagInstanceFactory;
import org.eclipse.jet.taglib.TagLibrary;

public class ExtensionTagDefinitionImpl
extends TagDefinitionImpl
implements TagDefinition,
CustomTagFactory {
    private static final String CLASS__ATTR = "class";
    private static final String USE__ATTR = "use";
    private static final String USE__VALUE__REQUIRED = "required";
    private static final String NAME__ATTR = "name";
    private static final String ATTRIBUTE__ELEMENT = "attribute";
    private static final String ALLOW_AS_EMPTY__ATTR = "allowAsEmpty";
    private static final String CONTENT_PROCESSING__VALUE__CUSTOM = "custom";
    private static final String CONTENT_PROCESSING__ATTR = "processContents";
    private static final String DEPRECATED__ATTR = "deprecated";
    private static final String TYPE__ATTR = "type";
    private static final String WHEN_CONTAINING_LINE_IS_EMPTY__ATTR = "whenContainingLineIsEmpty";
    private static final String REMOVE = "remove";
    private final IConfigurationElement configElement2;

    public static ExtensionTagDefinitionImpl createInstance(String tagName, IConfigurationElement configElement, CustomTagKind kind, ExtensionTagLibraryImpl tagLibrary) {
        boolean deprecated = Boolean.valueOf(configElement.getAttribute(DEPRECATED__ATTR));
        boolean customContentProcessing = CONTENT_PROCESSING__VALUE__CUSTOM.equals(configElement.getAttribute(CONTENT_PROCESSING__ATTR));
        boolean allowAsEmpty = Boolean.valueOf(configElement.getAttribute(ALLOW_AS_EMPTY__ATTR));
        String removeWhenEmpty = configElement.getAttribute(WHEN_CONTAINING_LINE_IS_EMPTY__ATTR);
        boolean removeWhenContainingLineIsEmpty = removeWhenEmpty == null ? kind != CustomTagKind.EMPTY && kind != CustomTagKind.FUNCTION : REMOVE.equals(removeWhenEmpty);
        String description = ExtensionTagLibraryImpl.getDescription(configElement).trim();
        ExtensionTagDefinitionImpl td = new ExtensionTagDefinitionImpl(configElement, tagLibrary, tagName, kind, description, customContentProcessing, allowAsEmpty, deprecated, removeWhenContainingLineIsEmpty);
        IConfigurationElement[] children = configElement.getChildren(ATTRIBUTE__ELEMENT);
        int i = 0;
        while (i < children.length) {
            TagAttributeDefinitionImpl tad = new TagAttributeDefinitionImpl(children[i].getAttribute(NAME__ATTR), USE__VALUE__REQUIRED.equalsIgnoreCase(children[i].getAttribute(USE__ATTR)), Boolean.valueOf(children[i].getAttribute(DEPRECATED__ATTR)), ExtensionTagLibraryImpl.getDescription(children[i]), children[i].getAttribute(TYPE__ATTR));
            if (tad.getName() != null) {
                td.addTagAttribute(tad);
            } else {
                String msg = JET2Messages.TagDefinitionImpl_MissingName;
                InternalJET2Platform.logError(MessageFormat.format(msg, children[i].getDeclaringExtension().getExtensionPointUniqueIdentifier(), children[i].getDeclaringExtension().getNamespace()));
            }
            ++i;
        }
        return td;
    }

    private ExtensionTagDefinitionImpl(IConfigurationElement configElement, TagLibrary tagLibrary, String tagName, CustomTagKind kind, String description, boolean customContentProcessing, boolean allowAsEmpty, boolean deprecated, boolean removeWhenContainingLineIsEmpty) {
        super(tagLibrary, tagName, kind, description, customContentProcessing, allowAsEmpty, deprecated, removeWhenContainingLineIsEmpty);
        this.configElement2 = configElement;
    }

    public CustomTag newTagElement() throws JET2TagException {
        TagInstanceFactory factory = ((ExtensionTagLibraryImpl)this.getTagLibrary()).getTagInstanceFactory();
        if (factory != null) {
            return factory.createCustomTag(this.getName());
        }
        try {
            return (CustomTag)this.configElement2.createExecutableExtension(CLASS__ATTR);
        }
        catch (CoreException e) {
            throw new JET2TagException((Throwable)e);
        }
    }
}

