/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.rules;

import java.util.Collection;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class WordListDetectorRule
implements IRule {
    private IToken success;
    private String[] words;

    public WordListDetectorRule(IToken token, String[] words) {
        this.success = token;
        this.words = words;
    }

    public WordListDetectorRule(IToken token, Collection words) {
        this.success = token;
        this.words = new String[words.size()];
        this.words = words.toArray(this.words);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char c;
        char initialChar = c = (char)scanner.read();
        int i = 0;
        while (i < this.words.length) {
            String keyword = this.words[i];
            int index = 0;
            while (keyword.length() > index && c == keyword.charAt(index)) {
                c = (char)scanner.read();
                ++index;
            }
            if (index == keyword.length()) {
                scanner.unread();
                return this.success;
            }
            int j = 0;
            while (j < index) {
                scanner.unread();
                ++j;
            }
            c = initialChar;
            ++i;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

