/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandBuilder
extends IncrementalProjectBuilder {
    private int incrementalAnalyzerStrategy;
    private Set<IXtendXpandResource> toAnalyze = null;

    private void updateIncrementalAnalyzerStrategy() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), Activator.getId());
        this.incrementalAnalyzerStrategy = scopedPreferenceStore.getInt("incrementalAnalyzerStrategy");
    }

    private boolean analyzeDependentProjectsWhenIncremental() {
        return this.incrementalAnalyzerStrategy == 0;
    }

    private boolean analyzeWholeProjectWhenIncremental() {
        switch (this.incrementalAnalyzerStrategy) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    boolean isOnJavaClassPath(IResource resource) {
        IJavaProject jp = JavaCore.create((IProject)resource.getProject());
        if (jp != null) {
            return jp.isOnClasspath(resource);
        }
        return false;
    }

    public static final String getBUILDER_ID() {
        return String.valueOf(Activator.getId()) + ".xtendBuilder";
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.toAnalyze = new HashSet<IXtendXpandResource>();
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.updateIncrementalAnalyzerStrategy();
        HashMap<IXtendXpandProject, ExecutionContext> projects = new HashMap<IXtendXpandProject, ExecutionContext>();
        for (IXtendXpandResource iXtendXpandResource : this.toAnalyze) {
            if (monitor.isCanceled()) break;
            IXtendXpandResource res = iXtendXpandResource;
            IResource resource = (IResource)res.getUnderlyingStorage();
            IProject project = resource.getProject();
            if (project.isLinked()) continue;
            IXtendXpandProject xtdxptProject = Activator.getExtXptModelManager().findProject((IResource)project);
            if (xtdxptProject != null && this.analyzeWholeProjectWhenIncremental()) {
                this.addProject(projects, xtdxptProject);
                continue;
            }
            res.analyze(Activator.getExecutionContext(JavaCore.create((IProject)project)));
        }
        for (Map.Entry entry : projects.entrySet()) {
            ((IXtendXpandProject)entry.getKey()).analyze(monitor, (ExecutionContext)entry.getValue());
        }
        return null;
    }

    private void addProject(Map<IXtendXpandProject, ExecutionContext> projects, IXtendXpandProject xtdxptProject) {
        if (projects.containsKey(xtdxptProject)) {
            return;
        }
        projects.put(xtdxptProject, Activator.getExecutionContext(xtdxptProject.getProject()));
        if (this.analyzeDependentProjectsWhenIncremental()) {
            for (IXtendXpandProject dependent : this.getDependentProjects(xtdxptProject)) {
                if (projects.containsKey(dependent)) continue;
                this.addProject(projects, dependent);
            }
        }
    }

    private Collection<IXtendXpandProject> getDependentProjects(IXtendXpandProject xtdxptProject) {
        ArrayList<IXtendXpandProject> result = new ArrayList<IXtendXpandProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)project);
            if (p != null && Arrays.asList(p.getReferencedProjects()).contains(xtdxptProject)) {
                result.add(p);
            }
            ++n2;
        }
        return result;
    }

    void reloadResource(IFile resource) {
        IXtendXpandResource r;
        IXtendXpandProject project;
        if (resource.exists() && (project = Activator.getExtXptModelManager().findProject((IResource)resource)) != null && (r = project.findXtendXpandResource((IStorage)resource)) != null) {
            if (r.refresh()) {
                resource.getLocalTimeStamp();
            }
            this.toAnalyze.add(r);
        }
    }

    public void handleRemovement(IFile resource) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject((IResource)resource);
        if (project != null) {
            project.unregisterXtendXpandResource(project.findXtendXpandResource((IStorage)resource));
        } else {
            XtendLog.logInfo("No Xpand project found for " + resource.getProject().getName());
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject(this.getProject().getFullPath());
        if (project != null) {
            ResourceContributor[] contributors;
            this.getProject().accept((IResourceVisitor)new XtendXpandDeltaVisitor(monitor));
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            HashSet<String> extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = Activator.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
            resourceContributorArray = roots;
            n = roots.length;
            n2 = 0;
            while (n2 < n) {
                ResourceContributor root = resourceContributorArray[n2];
                if (root.isArchive()) {
                    try {
                        root.open(monitor);
                        try {
                            ZipFile zip = ((JarPackageFragmentRoot)root).getJar();
                            Enumeration<? extends ZipEntry> entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                for (String ext : extensions) {
                                    String name = entry.getName();
                                    if (!name.endsWith(ext)) continue;
                                    String fqn = name.substring(0, name.length() - ext.length() - 1).replaceAll("/", "::");
                                    ResourceID resourceID = new ResourceID(fqn, ext);
                                    IStorage findStorage = JDTUtil.loadFromJar(resourceID, (IPackageFragmentRoot)root);
                                    project.findXtendXpandResource(findStorage);
                                }
                            }
                        }
                        finally {
                            root.close();
                        }
                    }
                    catch (CoreException ex) {
                        XtendLog.logError(ex);
                    }
                }
                ++n2;
            }
        } else {
            XtendLog.logInfo("Couldn't create Xpand project for project " + this.getProject().getName());
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        XtendXpandDeltaVisitor visitor = new XtendXpandDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
    }

    class XtendXpandDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private final IProgressMonitor monitor;
        private final Set<String> extensions;

        public XtendXpandDeltaVisitor(IProgressMonitor monitor) {
            ResourceContributor[] contributors;
            this.monitor = monitor;
            this.extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = Activator.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                this.extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this.isXtendXpandResource(resource)) {
                switch (delta.getKind()) {
                    case 1: {
                        XtendXpandMarkerManager.deleteMarkers(resource);
                        XtendXpandBuilder.this.reloadResource((IFile)resource);
                        break;
                    }
                    case 2: {
                        XtendXpandBuilder.this.handleRemovement((IFile)resource);
                        break;
                    }
                    case 4: {
                        XtendXpandBuilder.this.reloadResource((IFile)resource);
                    }
                }
            }
            this.monitor.worked(1);
            return true;
        }

        private boolean isXtendXpandResource(IResource resource) {
            return resource instanceof IFile && this.extensions.contains(((IFile)resource).getFileExtension()) && XtendXpandBuilder.this.isOnJavaClassPath(resource);
        }

        public boolean visit(IResource resource) {
            if (this.isXtendXpandResource(resource)) {
                XtendXpandBuilder.this.reloadResource((IFile)resource);
            }
            this.monitor.worked(1);
            return true;
        }
    }
}

