/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class UnicodeEscapeUtil {
    private final CharsetEncoder encoder;
    private final CharBuffer in;
    private ByteBuffer out;
    private CharBuffer unicodeEscapes;

    private UnicodeEscapeUtil(Charset charset, CharBuffer in) {
        this.in = in;
        this.encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPLACE);
        int capacity = (int)((float)in.remaining() * this.encoder.averageBytesPerChar());
        this.out = ByteBuffer.allocate(capacity);
        this.unicodeEscapes = CharBuffer.wrap("");
    }

    private ByteBuffer doEncode() throws CharacterCodingException {
        if (this.in.remaining() == 0) {
            return this.out;
        }
        this.encoder.reset();
        while (true) {
            CoderResult cr;
            if ((cr = this.unicodeEscapes.hasRemaining() ? this.encoder.encode(this.unicodeEscapes, this.out, false) : this.encoder.encode(this.in, this.out, false)).isUnderflow()) {
                if (!this.in.hasRemaining()) break;
                continue;
            }
            if (cr.isOverflow()) {
                int newCapacity = this.out.capacity() + (int)((float)(this.in.remaining() + this.unicodeEscapes.remaining()) * this.encoder.averageBytesPerChar());
                ByteBuffer newOut = ByteBuffer.allocate(newCapacity);
                this.out.flip();
                newOut.put(this.out);
                this.out = newOut;
                continue;
            }
            if (cr.isUnmappable()) {
                StringBuffer buffer = new StringBuffer(6 * cr.length());
                int i = 0;
                while (i < cr.length()) {
                    char ch = this.in.get();
                    buffer.append("\\u");
                    String hex = Integer.toHexString(ch);
                    int j = 4 - hex.length();
                    while (j > 0) {
                        buffer.append('0');
                        --j;
                    }
                    buffer.append(hex);
                    ++i;
                }
                this.unicodeEscapes = CharBuffer.wrap(buffer.toString());
                continue;
            }
            cr.throwException();
        }
        this.encoder.encode(this.in, this.out, true);
        this.encoder.flush(this.out);
        this.out.flip();
        return this.out;
    }

    public static ByteBuffer encode(CharBuffer buffer, Charset charset) throws CharacterCodingException {
        return new UnicodeEscapeUtil(charset, buffer).doEncode();
    }

    public static ByteBuffer encode(CharSequence contents, Charset charset) throws CharacterCodingException {
        return UnicodeEscapeUtil.encode(CharBuffer.wrap(contents), charset);
    }
}

