/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.internal.core.parser.LineInfo;

public final class TextElement
extends BodyElement {
    private static final String ESCAPED_JET_ELEMENT_START = "<\\%";
    private char[] text;
    private boolean trimLastLine = false;
    private boolean trimFirstLine = false;
    private final LineInfo[] lines;

    TextElement(JETAST jetast, char[] text) {
        super(jetast, -1, -1, 0, 0);
        this.text = this.handleEscapes(text);
        this.lines = LineInfo.calculateLines(this.text);
    }

    private char[] handleEscapes(char[] originalText) {
        StringBuffer buffer = new StringBuffer(originalText.length);
        buffer.append(originalText);
        int i = buffer.indexOf(ESCAPED_JET_ELEMENT_START);
        while (i != -1) {
            buffer.replace(i, i + ESCAPED_JET_ELEMENT_START.length(), "<%");
            i = buffer.indexOf(ESCAPED_JET_ELEMENT_START, i);
        }
        return buffer.toString().toCharArray();
    }

    protected void accept0(JETASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public char[] getText() {
        char[] result = this.text;
        if (this.lines.length > 0) {
            int start = this.isTrimFirstLine() && this.lines[0].hasDelimiter() ? this.lines[0].getEnd() + this.lines[0].getDelimiter().length() : 0;
            int end = this.isTrimLastLine() && !this.lines[this.lines.length - 1].hasDelimiter() ? this.lines[this.lines.length - 1].getStart() : this.text.length;
            result = new String(this.text, start, end - start).toCharArray();
        }
        return result;
    }

    public char[] getRawText() {
        return this.text;
    }

    void setText(char[] newText) {
        this.text = newText;
    }

    public boolean removeLineWhenOtherwiseEmpty() {
        return false;
    }

    public void setTrimLastLine(boolean trim) {
        this.trimLastLine = trim;
    }

    public final boolean isTrimLastLine() {
        return this.trimLastLine;
    }

    public void setTrimFirstLine(boolean trim) {
        this.trimFirstLine = trim;
    }

    public final boolean isTrimFirstLine() {
        return this.trimFirstLine;
    }

    public final LineInfo[] getLines() {
        return this.lines;
    }
}

