/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.cst.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.acceleo.internal.parser.cst.utils.ISequence;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
implements ISequence {
    private String[] tokens;
    private int lengthMin;

    public Sequence(String token) {
        this(new String[]{token});
    }

    public Sequence(String token1, String token2) {
        this(new String[]{token1, token2});
    }

    public Sequence(String token1, String token2, String token3) {
        this(new String[]{token1, token2, token3});
    }

    public Sequence(String token1, String token2, String token3, String token4) {
        this(new String[]{token1, token2, token3, token4});
    }

    public Sequence(String[] tokens) {
        this.tokens = tokens;
        this.lengthMin = 0;
        int i = 0;
        while (i < tokens.length) {
            this.lengthMin += tokens[i].length();
            ++i;
        }
    }

    private int indexOf(StringBuffer buffer, String tag, int posBegin, int posEnd) {
        int limit = posEnd - tag.length();
        int i = posBegin;
        while (i <= limit) {
            if (this.matches(buffer, tag, i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean matches(StringBuffer buffer, String tag, int pos) {
        int len = tag.length();
        int currentPos = pos;
        int index = 0;
        while (--len >= 0) {
            if (buffer.charAt(currentPos++) == tag.charAt(index++)) continue;
            return false;
        }
        return true;
    }

    public Region search(StringBuffer buffer) {
        return this.search(buffer, 0, buffer.length());
    }

    @Override
    public Region search(StringBuffer buffer, int posBegin, int posEnd) {
        if (buffer != null && posBegin >= 0 && this.tokens != null && this.tokens.length > 0) {
            int b = this.indexOf(buffer, this.tokens[0], posBegin, posEnd);
            while (b > -1) {
                Integer e = this.matchesEnd(buffer, b, posEnd);
                if (e != null && e > -1) {
                    return new Region(b, e, this);
                }
                b = this.indexOf(buffer, this.tokens[0], b + 1, posEnd);
            }
        }
        return Region.NOT_FOUND;
    }

    /*
     * Unable to fully structure code
     */
    private Integer matchesEnd(StringBuffer buffer, int posBegin, int posEnd) {
        e = this.tokens.length == 1 ? new Integer(posBegin + this.tokens[0].length()) : null;
        i = posBegin + this.tokens[0].length();
        j = 1;
        ** GOTO lbl14
        {
            ++i;
            do {
                if (i < posEnd && Character.isSpaceChar(buffer.charAt(i))) continue block0;
                if (this.tokens[j].length() <= 0 || i + this.tokens[j].length() > posEnd || !this.tokens[j].equals(buffer.substring(i, i + this.tokens[j].length()))) break block0;
                i += this.tokens[j].length();
                if (j + 1 == this.tokens.length) {
                    e = new Integer(i);
                    break block0;
                }
                ++j;
lbl14:
                // 2 sources

            } while (e == null && j < this.tokens.length);
        }
        return e;
    }

    @Override
    public Region search(StringBuffer buffer, int posBegin, int posEnd, Sequence spec, SequenceBlock[] inhibs) {
        Region result;
        if (spec == null && inhibs == null) {
            result = this.search(buffer, posBegin, posEnd);
        } else if (posBegin < 0) {
            result = Region.NOT_FOUND;
        } else {
            result = null;
            int currentPos = posBegin;
            int inhibsLength = 0;
            if (inhibs != null) {
                inhibsLength = inhibs.length;
            }
            Region[] positions = Region.createPositions(2 + inhibsLength);
            while (result == null && currentPos > -1 && currentPos < posEnd) {
                int iPositionMin = this.getOrCreateIndexOfNextPosition(positions, buffer, currentPos, posEnd, spec, inhibs);
                if (iPositionMin == -1) break;
                if (iPositionMin == 0) {
                    currentPos = positions[iPositionMin].e();
                    continue;
                }
                if (iPositionMin == 1) {
                    result = positions[iPositionMin];
                    continue;
                }
                if (iPositionMin < 2) continue;
                currentPos = inhibs[iPositionMin - 2].searchEndBodyAtBeginHeader(buffer, positions[iPositionMin], posEnd).e();
            }
            if (result == null) {
                result = Region.NOT_FOUND;
            }
        }
        return result;
    }

    private int getOrCreateIndexOfNextPosition(Region[] positions, StringBuffer buffer, int pos, int posEnd, Sequence spec, SequenceBlock[] inhibs) {
        if (positions[0].b() != -1 && spec != null && pos > positions[0].b()) {
            positions[0] = spec.search(buffer, pos, posEnd);
        }
        if (positions[1].b() != -1 && pos > positions[1].b()) {
            positions[1] = this.search(buffer, pos, posEnd);
        }
        int i = 2;
        while (i < positions.length) {
            if (positions[i].b() != -1 && pos > positions[i].b()) {
                positions[i] = inhibs[i - 2].searchBeginHeader(buffer, pos, posEnd);
            }
            ++i;
        }
        int positionMin = posEnd;
        int iPositionMin = -1;
        int i2 = 0;
        while (i2 < positions.length) {
            if (positions[i2].b() > -1 && positions[i2].b() < positionMin) {
                iPositionMin = i2;
                positionMin = positions[i2].b();
            }
            ++i2;
        }
        return iPositionMin;
    }

    public List<Region> split(StringBuffer buffer, int posBegin, int posEnd, boolean keepSeparator, Sequence spec, SequenceBlock[] inhibs) {
        LinkedList<Region> result = new LinkedList<Region>();
        if (buffer != null && buffer.length() > 0 && posEnd > 0 && posEnd > posBegin) {
            int currentPos = posBegin < 0 ? 0 : posBegin;
            while (currentPos > -1 && currentPos < posEnd) {
                Region index = this.search(buffer, currentPos, posEnd, spec, inhibs);
                if (index.b() == -1) {
                    if (posEnd <= currentPos) break;
                    result.add(new Region(currentPos, posEnd, this));
                    break;
                }
                if (index.b() > currentPos) {
                    result.add(new Region(currentPos, index.b(), this));
                }
                if (keepSeparator) {
                    result.add(index);
                }
                currentPos = index.e();
            }
        }
        return result;
    }
}

