/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.dialog;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class TreeSelectionComposite
extends Composite {
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private Listener listener;
    private boolean allowNewResourceName = true;
    private IResource selectedResource;
    private Text resourceNameField;
    private TreeViewer treeViewer;
    private ITreeContentProvider contentProvider;

    public TreeSelectionComposite(Composite parent, ITreeContentProvider contentProvider, Listener listener, boolean allowNewResourceName) {
        this(parent, contentProvider, listener, allowNewResourceName, null);
    }

    public TreeSelectionComposite(Composite parent, ITreeContentProvider contentProvider, Listener listener, boolean allowNewResourceName, String message) {
        this(parent, contentProvider, listener, allowNewResourceName, message, 300, 320);
    }

    public TreeSelectionComposite(Composite parent, ITreeContentProvider contentProvider, Listener listener, boolean allowNewResourceName, String message, int heightHint, int widthHint) {
        super(parent, 0);
        this.listener = listener;
        this.contentProvider = contentProvider;
        this.allowNewResourceName = allowNewResourceName;
        if (message != null) {
            this.createContents(message, heightHint, widthHint);
        } else if (allowNewResourceName) {
            this.createContents(AcceleoUIMessages.getString("TreeSelectionComposite.allowResourceCreation"), heightHint, widthHint);
        } else {
            this.createContents(AcceleoUIMessages.getString("TreeSelectionComposite.resourceSelecitonOnly"), heightHint, widthHint);
        }
    }

    public void resourceSelectionChanged(IResource resource) {
        this.selectedResource = resource;
        if (this.allowNewResourceName) {
            if (resource == null) {
                this.resourceNameField.setText("");
            } else {
                String text = TextProcessor.process((String)resource.getFullPath().makeRelative().toString());
                this.resourceNameField.setText(text);
                this.resourceNameField.setToolTipText(text);
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300, 320);
    }

    public void createContents(String message, int heightHint, int widthHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewResourceName) {
            this.resourceNameField = new Text((Composite)this, 2052);
            GridData gd = new GridData(768);
            gd.widthHint = widthHint;
            this.resourceNameField.setLayoutData((Object)gd);
            this.resourceNameField.addListener(24, this.listener);
            this.resourceNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(4, 4, true, true);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                TreeSelectionComposite.this.resourceSelectionChanged((IResource)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (TreeSelectionComposite.this.treeViewer.getExpandedState(item)) {
                        TreeSelectionComposite.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        TreeSelectionComposite.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getResourceFullPath() {
        IPath res = null;
        if (this.allowNewResourceName) {
            String pathName = this.resourceNameField.getText();
            if (pathName != null && pathName.length() > 0) {
                res = new Path(TextProcessor.deprocess((String)pathName)).makeAbsolute();
            }
        } else if (this.selectedResource != null) {
            res = this.selectedResource.getFullPath();
        }
        return res;
    }

    public void setInitialFocus() {
        if (this.allowNewResourceName) {
            this.resourceNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedResource(IResource resource) {
        this.selectedResource = resource;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = resource.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
    }
}

