/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityElement;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.emf.ecore.EObject;

public class TraceabilityRegion
extends TraceabilityElement {
    private int targetFileOffset;
    private int targetFileLength;
    private Block astNode;

    public TraceabilityRegion(int targetFileOffset, int targetFileLength, Block astNode) {
        this.targetFileOffset = targetFileOffset;
        this.targetFileLength = targetFileLength;
        this.astNode = astNode;
    }

    public int getTargetFileOffset() {
        return this.targetFileOffset;
    }

    public int getTargetFileLength() {
        return this.targetFileLength;
    }

    public Block getAstNode() {
        return this.astNode;
    }

    public void enlarge(int length) {
        this.targetFileLength += length;
    }

    public String toString() {
        if (this.astNode != null) {
            ModuleElement eModuleElement;
            String templateName = this.astNode.eResource().getURI().lastSegment();
            String templateDisplay = this.astNode instanceof ModuleElement ? String.valueOf('/') + templateName + '/' + ((ModuleElement)this.astNode).getName() : ((eModuleElement = this.getModuleElement((EObject)this.astNode)) != null ? String.valueOf('/') + templateName + '/' + eModuleElement.getName() + '/' + this.astNode.eClass().getName() : String.valueOf('/') + templateName + '/' + this.astNode.eClass().getName());
            return "[" + this.targetFileOffset + "," + (this.targetFileOffset + this.targetFileLength) + "] by '" + templateDisplay + "'";
        }
        return "";
    }

    private ModuleElement getModuleElement(EObject currentAstNode) {
        EObject current = currentAstNode;
        while (current != null) {
            if (current instanceof ModuleElement) {
                return (ModuleElement)current;
            }
            current = current.eContainer();
        }
        return null;
    }
}

